package net.polyv.vod.v1.entity.upload;

import java.io.File;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodCommonRequest;

/**
 * 上传视频封面图请求实体
 * @author: fangyan
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("上传视频封面图请求实体")
public class VodUploadVideoCoverImageRequest extends VodCommonRequest {
    
    /**
     * 用户id
     */
    @ApiModelProperty(hidden = true, name = "userId", value = "用户id", required = true)
    @NotNull(message = "属性userId不能为空")
    @JSONField(name = "userid")
    private String userId;
    
    /**
     * 视频id，多个视频id用英文逗号隔开，例如 e2e85038_e,e2e85039_e
     */
    @ApiModelProperty(name = "videoIds", value = "视频id，多个视频id用英文逗号隔开，例如 e2e85038_e,e2e85039_e", required = false)
    @JSONField(name = "vids")
    private String videoIds;
    
    /**
     * 分类id，多个分类id用英文逗号隔开，例如 1602300755037，1602300744037
     */
    @ApiModelProperty(name = "categoryIds", value = "分类id，多个分类id用逗号隔开", required = false)
    @JSONField(name = "cateIds")
    private String categoryIds;
    
    /**
     * 图片文件
     */
    @ApiModelProperty(name = "imageFile", value = "图片文件", required = false)
    private File imageFile;
    
    /**
     * 图片http url
     */
    @ApiModelProperty(name = "imageUrl", value = "图片http url", required = false)
    private String imageUrl;
    
    /**
     * 图片文件的base64形式
     */
    @ApiModelProperty(name = "imageBase64", value = "图片文件的base64形式", required = false)
    private String imageBase64;
    
}
