package net.polyv.vod.v1.entity.subaccount;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询子账号统计详情返回实体
 * @author: jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询子账号统计详情返回实体")
public class VodSubAccountStatsDetailResponse {
    
    @ApiModelProperty(name = "details", value = "查询的结果列表", required = false)
    private List<VodSubAccountStatsDetailResponse.VodStatsDetailList> details;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("查询的结果列表")
    public static class VodStatsDetailList {
        
        /**
         * 日期，格式：yyyy-MM-dd，如：2021-06-01
         */
        @ApiModelProperty(name = "currentDay", value = "日期，格式：yyyy-MM-dd，如：2021-06-01", required = false)
        private String currentDay;
        
        /**
         * PC端播放流量，单位：byte
         */
        @ApiModelProperty(name = "pcFlowSize", value = "PC端播放流量，单位：byte", required = false)
        private Long pcFlowSize;
        
        /**
         * 移动端播放流量，单位：byte
         */
        @ApiModelProperty(name = "mobileFlowSize", value = "移动端播放流量，单位：byte", required = false)
        private Long mobileFlowSize;
        
        /**
         * 总流量，单位：byte
         */
        @ApiModelProperty(name = "totalFlowSize", value = "总流量，单位：byte", required = false)
        private Long totalFlowSize;
        
        /**
         * PC端播放量，单位：个
         */
        @ApiModelProperty(name = "pcView", value = "PC端播放量，单位：个", required = false)
        private Long pcView;
        
        /**
         * 移动端播放量，单位：个
         */
        @ApiModelProperty(name = "mobileView", value = "移动端播放量，单位：个", required = false)
        private Long mobileView;
        
        /**
         * 总播放量，单位：个
         */
        @ApiModelProperty(name = "totalView", value = "总播放量，单位：个", required = false)
        private Long totalView;
        
        /**
         * PC端播放时长，单位：秒
         */
        @ApiModelProperty(name = "pcDuration", value = "PC端播放时长，单位：秒", required = false)
        private Long pcDuration;
        
        /**
         * 移动端播放时长，单位：秒
         */
        @ApiModelProperty(name = "mobileDuration", value = "移动端播放时长，单位：秒", required = false)
        private Long mobileDuration;
        
        /**
         * 总播放时长，单位：秒
         */
        @ApiModelProperty(name = "totalDuration", value = "总播放时长，单位：秒", required = false)
        private Long totalDuration;
        
        
    }
}
