/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.util;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.vod.v1.entity.VodCommonRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VodSignUtil {
    private static final Logger log = LoggerFactory.getLogger(VodSignUtil.class);

    public static String generateUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String setVodSign(Map<String, String> params, String appSecret) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String sign = VodSignUtil.getSign(params, appSecret);
        params.put("sign", sign);
        return sign;
    }

    public static String setVodMd5Sign(Map<String, String> params, String appSecret) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String sign = VodSignUtil.getMd5Sign(params, appSecret);
        params.put("sign", sign);
        return sign;
    }

    public static String getSign(Map<String, String> params, String secretKey) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        log.debug("\u53c2\u4e0e\u7b7e\u540d\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder buf = new StringBuilder();
        for (String key : keys) {
            if (null == params.get(key) || params.get(key).length() <= 0) continue;
            buf.append(key).append("=").append(params.get(key)).append("&");
        }
        String plain = buf.toString();
        if (StringUtils.isNotBlank((String)plain)) {
            plain = plain.substring(0, plain.length() - 1);
        }
        plain = plain + secretKey;
        log.debug("\u7b7e\u540d\u539f\u59cb\u5b57\u7b26\u4e32\uff1a{}", (Object)plain);
        String sign = VodSignUtil.getSha1(plain).toUpperCase();
        log.debug("\u7b7e\u540d\u7ed3\u679c\uff1a{}", (Object)sign);
        return sign;
    }

    public static String getMd5Sign(Map<String, String> params, String secretKey) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        log.debug("\u53c2\u4e0e\u7b7e\u540d\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder buf = new StringBuilder();
        for (String key : keys) {
            if (null == params.get(key) || params.get(key).length() <= 0) continue;
            buf.append(key).append(params.get(key));
        }
        String plain = buf.toString();
        plain = secretKey + plain + secretKey;
        log.debug("\u7b7e\u540d\u539f\u59cb\u5b57\u7b26\u4e32\uff1a{}", (Object)plain);
        String sign = VodSignUtil.md5Hex(plain).toUpperCase();
        log.debug("md5\u7b7e\u540d\u7ed3\u679c\uff1a{}", (Object)sign);
        return sign;
    }

    public static String md5Hex(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] inputByteArray = text.getBytes(Constant.UTF8_CHARSET);
        messageDigest.update(inputByteArray);
        byte[] resultByteArray = messageDigest.digest();
        return VodSignUtil.byteArrayToHex(resultByteArray).toLowerCase();
    }

    public static String byteArrayToHex(byte[] byteArray) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b & 0xF];
        }
        return new String(resultCharArray);
    }

    public static String getSha1(String input) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest mDigest = MessageDigest.getInstance("SHA1");
        byte[] result = mDigest.digest(input.getBytes(Constant.UTF8_CHARSET));
        StringBuilder sb = new StringBuilder();
        for (byte b : result) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static <T extends VodCommonRequest> Map<String, String> getSignMap(T t) {
        if (StringUtils.isBlank((String)t.getPtime())) {
            t.setPtime(String.valueOf(System.currentTimeMillis()));
        }
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("ptime", t.getPtime());
        tempMap.put("requestId", t.getRequestId());
        return tempMap;
    }
}

