/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.upload.service;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.vod.v1.config.VodGlobalConfig;
import net.polyv.vod.v1.entity.VodCommonRequest;
import net.polyv.vod.v1.entity.upload.vo.VodUploadConfigResponse;
import net.polyv.vod.v1.entity.upload.vo.VodUploadOSSTokenResponse;
import net.polyv.vod.v1.entity.upload.vo.VodUploadVideoConfigRequest;
import net.polyv.vod.v1.service.VodBaseService;
import net.polyv.vod.v1.util.VodSignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VodUploadVideoService
extends VodBaseService {
    private static final Logger log = LoggerFactory.getLogger(VodUploadVideoService.class);
    private static final String INIT_UPLOAD_TASK_URI = "http://api.polyv.net/v2/uploadvideo/%s/init";
    private static final String GET_TOKEN_URI = "http://api.polyv.net/v2/uploadvideo/%s/token";

    public VodUploadConfigResponse initUploadQueue(VodUploadVideoConfigRequest uploadConfigRequest, int retry) {
        VodUploadConfigResponse vodUploadVideoConfigResponse = null;
        try {
            vodUploadVideoConfigResponse = super.postFormBodyReturnOne(this.getFormatterUrl(INIT_UPLOAD_TASK_URI), uploadConfigRequest, VodUploadConfigResponse.class);
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20\u89c6\u9891\u57fa\u7840\u4fe1\u606f\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}\uff0c\u5f53\u524dretry\uff1a{}", new Object[]{uploadConfigRequest.getFile().getPath(), retry, e});
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u4e0a\u4f20\u89c6\u9891\u57fa\u7840\u4fe1\u606f\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}\uff0c\u5f53\u524dretry\uff1a{}", new Object[]{uploadConfigRequest.getFile().getPath(), retry, e});
        }
        if (vodUploadVideoConfigResponse == null) {
            if (retry > 0) {
                return this.initUploadQueue(uploadConfigRequest, --retry);
            }
            log.error("\u4e0a\u4f20\u89c6\u9891\u57fa\u7840\u4fe1\u606f\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}\uff0c\u5f53\u524dretry\uff1a{}", (Object)uploadConfigRequest.getFile().getPath(), (Object)retry);
            throw new PloyvSdkException(Constant.ERROR_CODE, "\u4e0a\u4f20\u89c6\u9891\u57fa\u7840\u4fe1\u606f\u5931\u8d25");
        }
        log.debug("\u4e0a\u4f20\u89c6\u9891\u57fa\u7840\u4fe1\u606f\u6210\u529f\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)uploadConfigRequest.getFile().getPath());
        return vodUploadVideoConfigResponse;
    }

    public VodUploadOSSTokenResponse getUploadToken(int retry) {
        VodUploadOSSTokenResponse vodUploadVideoConfigResponse = null;
        try {
            VodCommonRequest vodCommonRequest = new VodCommonRequest();
            vodCommonRequest.setRequestId(VodSignUtil.generateUUID());
            vodUploadVideoConfigResponse = super.getReturnOne(this.getFormatterUrl(GET_TOKEN_URI), vodCommonRequest, VodUploadOSSTokenResponse.class);
        }
        catch (IOException e) {
            log.info("\u91cd\u65b0\u83b7\u53d6token\u5931\u8d25", (Throwable)e);
            throw new PloyvSdkException(Constant.ERROR_CODE, "\u91cd\u65b0\u83b7\u53d6token\u5931\u8d25");
        }
        catch (NoSuchAlgorithmException e) {
            log.info("\u91cd\u65b0\u83b7\u53d6token\u5931\u8d25", (Throwable)e);
            throw new PloyvSdkException(Constant.ERROR_CODE, "\u91cd\u65b0\u83b7\u53d6token\u5931\u8d25");
        }
        if (vodUploadVideoConfigResponse == null) {
            if (retry > 0) {
                return this.getUploadToken(--retry);
            }
            throw new PloyvSdkException(Constant.ERROR_CODE, "\u91cd\u65b0\u83b7\u53d6token\u5931\u8d25");
        }
        return vodUploadVideoConfigResponse;
    }

    private String getFormatterUrl(String url) {
        return String.format(url, VodGlobalConfig.getUserId());
    }
}

