package net.polyv.vod.v1.service.play.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import net.polyv.vod.v1.config.VodGlobalConfig;
import net.polyv.vod.v1.constant.VodURL;
import net.polyv.vod.v1.entity.play.list.VodAddVideoToPlayListRequest;
import net.polyv.vod.v1.entity.play.list.VodCreatePlayListRequest;
import net.polyv.vod.v1.entity.play.list.VodCreatePlayListResponse;
import net.polyv.vod.v1.entity.play.list.VodGetOnePlayListRequest;
import net.polyv.vod.v1.entity.play.list.VodGetOnePlayListResponse;
import net.polyv.vod.v1.entity.play.list.VodGetPlayListInfoRequest;
import net.polyv.vod.v1.entity.play.list.VodGetPlayListInfoResponse;
import net.polyv.vod.v1.entity.play.list.VodRemoveVideoFromPlayListRequest;
import net.polyv.vod.v1.entity.play.list.VodUpdatePlayListRequest;
import net.polyv.vod.v1.entity.play.list.VodUpdatePlayListResponse;
import net.polyv.vod.v1.service.VodBaseService;
import net.polyv.vod.v1.service.play.IVodPlayListService;

/**
 * 播放列表
 * @author: fangyan
 */
public class VodPlayListServiceImpl extends VodBaseService implements IVodPlayListService {
    
    /**
     * 获取单个播放列表
     * API地址：https://dev.polyv.net/2017/videoproduct/v-api/v-api-play/v-api-play-playlist/play-list/
     * 新接口：net.polyv.vod.v1.service.play.impl.VodPlayListServiceImpl#getPlayListInfo(net.polyv.vod.v1.entity.play
     * .list.VodGetPlayListInfoRequest)
     * @param vodGetOnePlayListRequest 获取单个播放列表请求实体
     * @return 获取单个播放列表返回实体列表
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Deprecated
    @Override
    public List<VodGetOnePlayListResponse> getOnePlayList(VodGetOnePlayListRequest vodGetOnePlayListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl(VodURL.VOD_GET_ONE_PLAY_LIST_URL, VodGlobalConfig.getUserId(),
                vodGetOnePlayListRequest.getId());
        return super.getReturnList(url, vodGetOnePlayListRequest, VodGetOnePlayListResponse.class);
    }
    
    /**
     * 获取播放列表信息
     * @param vodGetPlayListInfoRequest 获取播放列表信息请求实体
     * @return 获取播放列表信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public VodGetPlayListInfoResponse getPlayListInfo(VodGetPlayListInfoRequest vodGetPlayListInfoRequest)
            throws IOException, NoSuchAlgorithmException {
        vodGetPlayListInfoRequest.setUserId(VodGlobalConfig.getUserId());
        return super.getReturnOne(VodURL.VOD_GET_PLAY_LIST_URL, vodGetPlayListInfoRequest,
                VodGetPlayListInfoResponse.class);
    }
    
    /**
     * 创建播放列表
     * API地址：https://dev.polyv.net/2021/uncategorized/create-play-list/
     * @param vodCreatePlayListRequest 创建播放列表请求实体
     * @return 创建播放列表返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public VodCreatePlayListResponse createPlayList(VodCreatePlayListRequest vodCreatePlayListRequest)
            throws IOException, NoSuchAlgorithmException {
        vodCreatePlayListRequest.setUserId(VodGlobalConfig.getUserId());
        return super.postFormBodyReturnOne(VodURL.VOD_CREATE_PLAY_LIST_URL, vodCreatePlayListRequest,
                VodCreatePlayListResponse.class);
    }
    
    /**
     * 修改播放列表信息
     * API地址：https://dev.polyv.net/2021/uncategorized/update-play-list/
     * @param vodUpdatePlayListRequest 修改播放列表信息请求实体
     * @return 修改播放列表信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public VodUpdatePlayListResponse updatePlayList(VodUpdatePlayListRequest vodUpdatePlayListRequest)
            throws IOException, NoSuchAlgorithmException {
        vodUpdatePlayListRequest.setUserId(VodGlobalConfig.getUserId());
        return super.postFormBodyReturnOne(VodURL.VOD_UPDATE_PLAY_LIST_URL, vodUpdatePlayListRequest,
                VodUpdatePlayListResponse.class);
    }
    
    /**
     * 添加视频至播放列表
     * API地址：https://dev.polyv.net/2021/uncategorized/add-video-to-play-list/
     * @param vodAddVideoToPlayListRequest 添加视频至播放列表请求实体
     * @return Boolean
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean addVideoToPlayList(VodAddVideoToPlayListRequest vodAddVideoToPlayListRequest)
            throws IOException, NoSuchAlgorithmException {
        vodAddVideoToPlayListRequest.setUserId(VodGlobalConfig.getUserId());
        super.postFormBodyReturnOne(VodURL.VOD_ADD_VIDEO_TO_PLAY_LIST_URL, vodAddVideoToPlayListRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 将视频从播放列表移除
     * API地址：https://dev.polyv.net/2021/uncategorized/remove-video-from-play-list/
     * @param vodRemoveVideoFromPlayListRequest 将视频从播放列表移除请求实体
     * @return Boolean
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean removeVideoFromPlayList(VodRemoveVideoFromPlayListRequest vodRemoveVideoFromPlayListRequest)
            throws IOException, NoSuchAlgorithmException {
        vodRemoveVideoFromPlayListRequest.setUserId(VodGlobalConfig.getUserId());
        super.postFormBodyReturnOne(VodURL.VOD_REMOVE_VIDEO_FROM_PLAY_LIST_URL, vodRemoveVideoFromPlayListRequest,
                String.class);
        return Boolean.TRUE;
    }
}
