package net.polyv.vod.v1.service.manage.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.vod.v1.constant.VodURL;
import net.polyv.vod.v1.entity.manage.query.VodQueryVideoListRequest;
import net.polyv.vod.v1.entity.manage.query.VodQueryVideoListResponse;
import net.polyv.vod.v1.entity.manage.query.VodSearchVideoListRequest;
import net.polyv.vod.v1.entity.manage.query.VodSearchVideoListResponse;
import net.polyv.vod.v1.service.VodBaseService;
import net.polyv.vod.v1.service.manage.IVodQueryService;

/**
 * @author: sadboy
 **/
public class VodQueryServiceImpl extends VodBaseService implements IVodQueryService {
    
    /**
     * 根据授权播放开关状态查找视频
     * API地址：https://dev.polyv.net/2017/videoproduct/v-api/v-api-vmanage/v-api-vmanage-search/list-by-playauth/
     * 新接口：net.polyv.vod.v1.service.manage.impl.VodListServiceImpl#vodGetVideoList(net.polyv.vod.v1.entity.manage.list.VodGetVideoListRequest)
     * @param vodQueryVideoListRequest 根据授权播放开关状态查找视频请求实体
     * @return 根据授权播放开关状态查找视频返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Deprecated
    @Override
    public VodQueryVideoListResponse queryVideoList(VodQueryVideoListRequest vodQueryVideoListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl(VodURL.QUERY_VIDEO_LIST_URL);
        VodQueryVideoListResponse vodQueryVideoListResponse = super.getReturnOne(url, vodQueryVideoListRequest,
                VodQueryVideoListResponse.class);
        vodQueryVideoListResponse.setPageSize(vodQueryVideoListRequest.getPageSize());
        return vodQueryVideoListResponse;
    }
    
    /**
     * 查找视频
     * API地址：https://dev.polyv.net/2017/videoproduct/v-api/v-api-vmanage/v-api-vmanage-search/search-videos/
     * 新接口：net.polyv.vod.v1.service.manage.impl.VodListServiceImpl#vodGetVideoList(net.polyv.vod.v1.entity.manage.list.VodGetVideoListRequest)
     * @param vodSearchVideoListRequest 查找视频请求实体
     * @return 查找视频返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Deprecated
    @Override
    public VodSearchVideoListResponse searchVideoList(VodSearchVideoListRequest vodSearchVideoListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl(VodURL.SEARCH_VIDEO_LIST_URL);
        return super.postFormBodyReturnOne(url, vodSearchVideoListRequest, VodSearchVideoListResponse.class);
    }
}
