package net.polyv.vod.v1.service.manage.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.vod.v1.config.VodGlobalConfig;
import net.polyv.vod.v1.constant.VodURL;
import net.polyv.vod.v1.entity.manage.list.VodGetByUploaderRequest;
import net.polyv.vod.v1.entity.manage.list.VodGetByUploaderResponse;
import net.polyv.vod.v1.entity.manage.list.VodGetDelListRequest;
import net.polyv.vod.v1.entity.manage.list.VodGetDelListResponse;
import net.polyv.vod.v1.entity.manage.list.VodGetHotListRequest;
import net.polyv.vod.v1.entity.manage.list.VodGetHotListResponse;
import net.polyv.vod.v1.entity.manage.list.VodGetIllegalListRequest;
import net.polyv.vod.v1.entity.manage.list.VodGetIllegalListResponse;
import net.polyv.vod.v1.entity.manage.list.VodGetNewListRequest;
import net.polyv.vod.v1.entity.manage.list.VodGetNewListResponse;
import net.polyv.vod.v1.entity.manage.list.VodGetVideoListRequest;
import net.polyv.vod.v1.entity.manage.list.VodGetVideoListResponse;
import net.polyv.vod.v1.service.VodBaseService;
import net.polyv.vod.v1.service.manage.IVodListService;

/**
 * 视频列表
 * @author: fangyan
 */
public class VodListServiceImpl extends VodBaseService implements IVodListService {
    
    /**
     * 查询视频列表
     * API地址：https://dev.polyv.net/2021/uncategorized/search-videos-2/
     * @param vodGetVideoListRequest 查询视频列表请求实体
     * @return 查询视频列表返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public VodGetVideoListResponse getVideoList(VodGetVideoListRequest vodGetVideoListRequest)
            throws IOException, NoSuchAlgorithmException {
        vodGetVideoListRequest.setUserId(VodGlobalConfig.getUserId());
        return super.getReturnOne(VodURL.VOD_SEARCH_VIDEOS_URL, vodGetVideoListRequest, VodGetVideoListResponse.class);
    }
    
    /**
     * 获取某分类下某子账号的视频列表
     * API地址：https://dev.polyv.net/2018/videoproduct/v-api/v-api-vmanage/v-api-vmanage-list/get-by-uploader/
     * 新接口：net.polyv.vod.v1.service.manage.impl.VodListServiceImpl#getVideoList(net.polyv.vod.v1.entity.manage
     * .list.VodGetVideoListRequest)
     * @param vodGetByUploaderRequest 获取某分类下某子账号的视频列表请求实体
     * @return 获取某分类下某子账号的视频列表返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Deprecated
    @Override
    public VodGetByUploaderResponse getByUploader(VodGetByUploaderRequest vodGetByUploaderRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl(VodURL.VOD_GET_BY_UPLOADER_URL);
        return super.getReturnOne(url, vodGetByUploaderRequest, VodGetByUploaderResponse.class);
    }
    
    /**
     * 获取最新视频/全部视频列表
     * API地址：https://dev.polyv.net/2017/videoproduct/v-api/v-api-vmanage/v-api-vmanage-list/get-new-list/
     * 新接口：net.polyv.vod.v1.service.manage.impl.VodListServiceImpl#getVideoList(net.polyv.vod.v1.entity.manage
     * .list.VodGetVideoListRequest)
     * @param vodGetNewListRequest 获取最新视频/全部视频列表请求实体
     * @return 获取最新视频/全部视频列表返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Deprecated
    @Override
    public VodGetNewListResponse getNewList(VodGetNewListRequest vodGetNewListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl(VodURL.VOD_GET_NEW_LIST_URL);
        return super.postFormBodyReturnOne(url, vodGetNewListRequest, VodGetNewListResponse.class);
    }
    
    /**
     * 获取最热视频列表
     * API地址：https://dev.polyv.net/2017/videoproduct/v-api/v-api-vmanage/v-api-vmanage-list/get-host-list/
     * 新接口：net.polyv.vod.v1.service.manage.impl.VodListServiceImpl#getVideoList(net.polyv.vod.v1.entity.manage
     * .list.VodGetVideoListRequest)
     * @param vodGetHotListRequest 获取最热视频列表请求实体
     * @return 获取最热视频列表返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Deprecated
    @Override
    public VodGetHotListResponse getHotList(VodGetHotListRequest vodGetHotListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl(VodURL.VOD_GET_HOT_LIST_URL);
        return super.postFormBodyReturnOne(url, vodGetHotListRequest, VodGetHotListResponse.class);
    }
    
    /**
     * 获取视频回收站列表
     * API地址：https://dev.polyv.net/2017/videoproduct/v-api/v-api-vmanage/v-api-vmanage-list/get-del-list/
     * 新接口：net.polyv.vod.v1.service.manage.impl.VodListServiceImpl#getVideoList(net.polyv.vod.v1.entity.manage
     * .list.VodGetVideoListRequest)
     * @param vodGetDelListRequest 获取视频回收站列表请求实体
     * @return 获取视频回收站列表返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Deprecated
    @Override
    public VodGetDelListResponse getDelList(VodGetDelListRequest vodGetDelListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl(VodURL.VOD_GET_DEL_LIST_URL);
        return super.postFormBodyReturnOne(url, vodGetDelListRequest, VodGetDelListResponse.class);
    }
    
    /**
     * 获取不通过视频列表
     * API地址：https://dev.polyv.net/2013/videoproduct/v-api/v-api-vmanage/v-api-vmanage-list/getnotpasslist/
     * 新接口：net.polyv.vod.v1.service.manage.impl.VodListServiceImpl#getVideoList(net.polyv.vod.v1.entity.manage
     * .list.VodGetVideoListRequest)
     * @param vodGetIllegalListRequest 获取不通过视频列表请求实体
     * @return 获取不通过视频列表返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Deprecated
    @Override
    public VodGetIllegalListResponse getIllegalList(VodGetIllegalListRequest vodGetIllegalListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl(VodURL.VOD_GET_ILLEGAL_LIST_URL);
        return super.postFormBodyReturnOne(url, vodGetIllegalListRequest, VodGetIllegalListResponse.class);
    }
}
