package net.polyv.vod.v1.entity.subaccount;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodPageCommonRequest;
import net.polyv.vod.v1.entity.VodSubCommonRequest;
import net.polyv.vod.v1.entity.VodSubPageCommonRequest;

/**
 * 查询子账号统计汇总数据请求实体
 * @author: jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询子账号统计汇总数据请求实体")
public class VodSubAccountStatsAggPageRequest extends VodPageCommonRequest {
    
    /**
     * POLYV用户userid，通过注册保利威官网获取，路径：官网->登录->点播（API接口）
     */
    @ApiModelProperty(hidden = true)
    @NotNull(message = "属性userId不能为空")
    @JSONField(name = "userid")
    private String userId;
    
    /**
     * 开始日期，格式为：yyyy-MM-dd，例如：2021-04-07，时间跨度不能超过一年
     */
    @ApiModelProperty(name = "startDate", value = "查询的开始时间，格式要求：yyyy-MM-dd，时间跨度不能超过一年", required = true)
    @NotNull(message = "属性startDate不能为空")
    @JSONField(format = "yyyy-MM-dd")
    private Date startDate;
    
    /**
     * 结束日期，格式为：yyyy-MM-dd，例如：2021-04-10，时间跨度不能超过一年
     */
    @ApiModelProperty(name = "endDate", value = "查询的结束时间，格式要求：yyyy-MM-dd，时间跨度不能超过一年", required = true)
    @NotNull(message = "属性endDate不能为空")
    @JSONField(format = "yyyy-MM-dd")
    private Date endDate;
    
    /**
     * 要查询的子账号邮箱，如果同时传了email和appId，则优先使用email
     */
    @ApiModelProperty(name = "email", value = "要查询的子账号邮箱，如果同时传了email和appId，则优先使用email", required = false)
    private String email;
    
    /**
     * 要查询的子账号appId
     */
    @ApiModelProperty(name = "appId", value = "要查询的子账号appId", required = false)
    private String appId;
}
