package net.polyv.vod.v1.entity.play.list;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodPageCommonRequest;

/**
 * 获取播放列表信息请求实体
 * @author: fangyan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("获取播放列表信息请求实体")
public class VodGetPlayListInfoRequest extends VodPageCommonRequest {
    
    /**
     * 用户ID
     */
    @ApiModelProperty(hidden = true, name = "userId", value = "用户ID", required = true)
    @NotNull(message = "属性userId不能为空")
    @JSONField(name = "userid")
    private String userId;
    
    /**
     * 播放列表ID，多个以英文逗号分隔，最大1000个，如“1620153765497,1620142496099”
     */
    @ApiModelProperty(name = "playListIds", value = "播放列表ID，多个以英文逗号分隔，最大1000个，如“1620153765497,1620142496099”",
            required = false)
    private String playListIds;
    
    /**
     * 标题，按标题模糊搜索
     */
    @ApiModelProperty(name = "title", value = "标题，按标题模糊搜索", required = false)
    private String title;
}
