package net.polyv.vod.v1.entity.play.list;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodCommonRequest;

/**
 * 创建播放列表请求实体
 * @author: fangyan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("创建播放列表请求实体")
public class VodCreatePlayListRequest extends VodCommonRequest {
    
    /**
     * 用户ID
     */
    @ApiModelProperty(hidden = true, name = "userId", value = "用户ID", required = true)
    @NotNull(message = "属性userId不能为空")
    @JSONField(name = "userid")
    private String userId;
    
    /**
     * 标题
     */
    @ApiModelProperty(name = "title", value = "标题", required = true)
    @NotNull(message = "属性title不能为空")
    private String title;
    
    /**
     * 描述
     */
    @ApiModelProperty(name = "description", value = "描述", required = false)
    private String description;
    
    /**
     * 标签
     */
    @ApiModelProperty(name = "tag", value = "标签", required = false)
    private String tag;
}
