package net.polyv.vod.v1.entity.manage.info;

import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodCommonRequest;

/**
 * 新增或修改视频问答请求实体
 * @author: fangyan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("新增或修改视频问答请求实体")
public class VodCreateOrUpdateVideoExamRequest extends VodCommonRequest {
    /**
     * 用户ID
     */
    @ApiModelProperty(hidden = true, name = "userId", value = "用户ID", required = true)
    @NotNull(message = "属性userId不能为空")
    @JSONField(name = "userid")
    private String userId;
    
    /**
     * 视频ID
     */
    @ApiModelProperty(name = "videoId", value = "视频ID", required = true)
    @NotNull(message = "属性videoId不能为空")
    @JSONField(name = "vid")
    private String videoId;
    
    /**
     * 问答ID，为空时会新增一个题目。不为空时会修改已有的问答题目
     */
    @ApiModelProperty(name = "examId", value = "问答ID，为空时会新增一个题目。不为空时会修改已有的问答题目", required = false)
    private String examId;
    
    /**
     * 问答出现的时间，单位：秒
     */
    @ApiModelProperty(name = "showTime", value = "问答出现的时间，单位：秒", required = true)
    @NotNull(message = "属性showTime不能为空")
    private Integer showTime;
    
    /**
     * 问答题目描述
     */
    @ApiModelProperty(name = "question", value = "问答题目描述", required = true)
    @NotNull(message = "属性question不能为空")
    private String question;
    
    /**
     * 问答选项，每个题目最多5个选项。
     */
    @ApiModelProperty(name = "choices", value = "问答选项json数组，每个题目最多5个选项。", required = true)
    @NotNull(message = "属性choices不能为空")
    private List<Choices> choices;
    
    /**
     * 是否可跳过，默认值：false
     */
    @ApiModelProperty(name = "canSkip", value = "是否可跳过，默认值：false", required = false)
    private Boolean canSkip;
    
    /**
     * 回答正确后的解答详情
     */
    @ApiModelProperty(name = "explanationIfRight", value = "回答正确后的解答详情", required = false)
    private String explanationIfRight;
    
    /**
     * 回答答错误后是否显示解答详情，true：显示；false：不显示；默认为true显示
     */
    @ApiModelProperty(name = "showExplanationIfWrong", value = "回答答错误后是否显示解答详情，true：显示；false：不显示；默认为true显示",
            required = false)
    private Boolean showExplanationIfWrong;
    
    /**
     * 回答错误后的解答详情
     */
    @ApiModelProperty(name = "explanationIfWrong", value = "回答错误后的解答详情", required = false)
    private String explanationIfWrong;
    
    /**
     * 答错后回退到第几秒，-1代表不回退，默认为-1
     */
    @ApiModelProperty(name = "backTime", value = "答错后回退到第几秒，-1代表不回退，默认为-1", required = false)
    private Integer backTime;
    
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Accessors(chain = true)
    @ApiModel("问答选项")
    public static class Choices {
        /**
         * 选项序号，题目实际顺序为按此值的大小排序，不要重复
         */
        @ApiModelProperty(name = "index", value = "选项序号，题目实际顺序为按此值的大小排序，不要重复", required = true)
        @NotNull(message = "属性index不能为空")
        private Integer index;
        
        /**
         * 选项内容
         */
        @ApiModelProperty(name = "content", value = "选项内容", required = true)
        @NotNull(message = "属性content不能为空")
        private String content;
        
        /**
         * 所有选项中必须至少有一个设置为正确答案，否则接口返回错误。
         */
        @ApiModelProperty(name = "isRight", value = "所有选项中必须至少有一个设置为正确答案，否则接口返回错误。", required = false)
        private Boolean isRight;
        
    }
}
