package net.polyv.vod.v1.entity.manage.info;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodCommonRequest;

/**
 * 查询视频信息请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询视频信息请求实体")
public class VodAccountQueryVideoInfoRequest extends VodCommonRequest {
    
    /**
     * 视频id（可以支持多个，用英文逗号隔开）
     */
    @ApiModelProperty(name = "videoIds", value = "视频id（可以支持多个，用英文逗号隔开）", required = true)
    @NotNull(message = "属性videoIds不能为空")
    @JSONField(name = "vid")
    private String videoIds;
    
}