package net.polyv.vod.v1.entity.datastatistics;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 分类统计响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("分类统计响应实体")
public class VodGetCataStatsResponse {
    /**
     * 日期，格式为：yyyy-MM-dd
     */
    @ApiModelProperty(name = "current", value = "日期，格式为：yyyy-MM-dd", required = false)
    @JSONField(format = "yyyy-MM-dd")
    private Date current;
    
    /**
     * PC端播放量
     */
    @ApiModelProperty(name = "pcVideoView", value = "PC端播放量", required = false)
    private Integer pcVideoView;
    
    /**
     * 移动端播放量
     */
    @ApiModelProperty(name = "mobileVideoView", value = "移动端播放量", required = false)
    private Integer mobileVideoView;
    
    /**
     * PC端消耗流量，单位：字节
     */
    @ApiModelProperty(name = "pcFlowSize", value = "PC端消耗流量，单位：字节", required = false)
    private Long pcFlowSize;
    
    /**
     * 移动端消耗流量，单位：字节
     */
    @ApiModelProperty(name = "mobileFlowSize", value = "移动端消耗流量，单位：字节", required = false)
    private Long mobileFlowSize;
    
    /**
     * PC端播放时长，单位：秒
     */
    @ApiModelProperty(name = "pcPlayDuration", value = "PC端播放时长，单位：秒", required = false)
    private Integer pcPlayDuration;
    
    /**
     * 移动端播放时长，单位：秒
     */
    @ApiModelProperty(name = "mobilePlayDuration", value = "移动端播放时长，单位：秒", required = false)
    private Integer mobilePlayDuration;
    
    /**
     * PC端唯一观众数
     */
    @ApiModelProperty(name = "pcUniqueViewer", value = "PC端唯一观众数", required = false)
    private Integer pcUniqueViewer;
    
    /**
     * 移动端唯一观众数
     */
    @ApiModelProperty(name = "mobileUniqueViewer", value = "移动端唯一观众数", required = false)
    private Integer mobileUniqueViewer;
    
}