package net.polyv.vod.v1.entity.datastatistics;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodCommonRequest;

/**
 * 分类统计请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("分类统计请求实体")
public class VodGetCataStatsRequest extends VodCommonRequest {
    /**
     * 分类id
     */
    @ApiModelProperty(name = "cataid", value = "分类id", required = true)
    @NotNull(message = "属性cataid不能为空")
    private String cataid;
    /**
     * 时间段，具体值为以下几个，默认值为7days today：今天 yesterday：昨天 this_week：本周 last_week：上周 7days：最近7天 this_month：本月 last_month：上个月
     * this_year：今年 last_year：去年
     */
    @ApiModelProperty(name = "dr", value = "时间段，具体值为以下几个：today（今天），yesterday（昨天），this_week（本周），last_week（上周），7days" +
            "(最近7天），this_month（本月），last_month（上个月），this_year（今年），last_year（去年），默认值为7days:最近7天", required = false)
    private String dr;
    /**
     * 开始日期，格式为：yyyy-MM-dd，例如：2021-04-07
     */
    @ApiModelProperty(name = "startDate", value = "开始日期，格式为：yyyy-MM-dd", required = false)
    @JSONField(name = "startDate", format = "yyyy-MM-dd")
    private Date startTime;
    /**
     * 结束日期，格式为：yyyy-MM-dd，例如：2021-04-10
     */
    @ApiModelProperty(name = "endDate", value = "结束日期，格式为：yyyy-MM-dd", required = false)
    @JSONField(name = "endDate", format = "yyyy-MM-dd")
    private Date endTime;
    /**
     * 是否包含子分类的数据 Y：是 N：否
     */
    @ApiModelProperty(name = "containSubCategory", value = "是否包含子分类的数据 Y：是 N：否", required = false)
    private String containSubCategory;
}