package net.polyv.vod.v1.config;

import java.io.File;

import lombok.Data;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.StringUtils;

/**
 * 点播上传配置信息
 * @author: sadboy
 **/
@Data
public class UploadConfig {
    
    /**
     * 上传分片大小
     */
    private int partitionSize = 1024 * 1024;
    
    /**
     * 分片上传进度文件存放位置
     */
    private String checkpoint = "checkpoint_lcoation";
    
    /**
     * 上传线程数，根据服务器实际情况设置
     */
    private int threadNum = 5;
    
    public UploadConfig() {
        checkArgument();
    }
    
    public UploadConfig(int partitionSize, String checkpoint, int threadNum) {
        this.partitionSize = partitionSize;
        this.checkpoint = checkpoint;
        this.threadNum = threadNum;
        checkArgument();
    }
    
    /**
     * 验证参数及创建分片上传进度存放文件夹
     */
    private void checkArgument() {
        if (StringUtils.isBlank(checkpoint)) {
            throw new PloyvSdkException(Constant.ERROR_CODE, "PolyvUploadClient中checkpoint参数不能为空");
        }
        File checkpointFile = new File(checkpoint);
        if (!checkpointFile.exists() && !checkpointFile.mkdirs()) {
            throw new PloyvSdkException(Constant.ERROR_CODE, "PolyvUploadClient中checkpoint路径创建失败，请检查权限。");
        }
        if (threadNum <= 0) {
            threadNum = 5;
        }
        if (partitionSize < 100 * 1024 || partitionSize > 5 * 1024 * 1024 * 1024) {
            partitionSize = 100 * 1024;
        }
    }
}
