package net.polyv.vod.v1.entity.upload;

import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.vod.v1.entity.VodCommonRequest;

/**
 * 远程批量上传视频请求实体
 * @author: sadboy
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("远程批量上传视频请求实体")
public class VodUploadHttpVideoListRequest extends VodCommonRequest {
    
    /**
     * 远程文件的http链接(带http://)，多个地址间使用英文逗号隔开，已不建议使用，请使用 uploadInfos 参数
     */
    @ApiModelProperty(name = "fileUrl", value = "远程文件的http链接(带http://)，多个地址间使用英文逗号隔开，已不建议使用，请使用 uploadInfos 参数", required = false)
    @Deprecated
    private String fileUrl;
    
    /**
     * 标题，多个标题使用逗号隔开(标题数量必须和文件地址数量一致)
     */
    @ApiModelProperty(name = "title", value = "标题，多个标题使用逗号隔开(标题数量必须和文件地址数量一致)", required = false)
    @Deprecated
    private String title;
    
    /**
     * 设定上传视频的分类，当categoryId值为1时，表示用户上传空间的根目录。
     */
    @ApiModelProperty(name = "categoryId", value = "设定上传视频的分类，当categoryId值为1时，表示用户上传空间的根目录。", required = false)
    @JSONField(name = "cataid")
    private String categoryId;
    
    /**
     * 是否录屏优化。当值为1时，上传的视频不再采取默认的压缩编码机制，视频尺寸不再压缩，保证视频的清晰度。默认值为0
     */
    @ApiModelProperty(name = "screenCap", value = "是否录屏优化。当值为1时，上传的视频不再采取默认的压缩编码机制，视频尺寸不再压缩，保证视频的清晰度。默认值为0", required = false)
    @JSONField(name = "luping")
    private Integer screenCap;
    
    /**
     * 自定义水印图片地址,图片格式必须是png格式，支持http、https。
     */
    @ApiModelProperty(name = "watermark", value = "自定义水印图片地址,图片格式必须是png格式，支持http、https。", required = false)
    private String watermark;
    
    /**
     * 自定义水印图片位置，如没该参数，则自定义水印的显示情况跟随分类或账号设置。1：左上角；2：右上角；3：左下角；4：右下角
     */
    @ApiModelProperty(name = "watermarkLocation", value = "自定义水印图片位置，如没该参数，则自定义水印的显示情况跟随分类或账号设置。1：左上角；2：右上角；3：左下角；4：右下角", required = false)
    private String watermarkLocation;
    
    /**
     * 上传视频信息json数组，最多100个
     */
    @ApiModelProperty(name = "uploadInfos", value = "上传视频信息json数组，最多100个", required = false)
    private List<UploadInfos> uploadInfos;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("远程上传的视频信息")
    public static class UploadInfos{
    
        /**
         * 待上传视频的URL，支持http、https协议，长度限制：1000 个字符
         */
        @ApiModelProperty(name = "fileUrl", value = "待上传视频的URL，支持http、https协议，长度限制：1000 个字符", required = false)
        private String fileUrl;
    
        /**
         * 视频标题，长度限制：100 个字符
         */
        @ApiModelProperty(name = "title", value = "视频标题，长度限制：100 个字符", required = false)
        private String title;
    
        /**
         * 自定义数据，长度限制：100 个字符，如果提交了该字段，会在上传完成回调时透传返回
         */
        @ApiModelProperty(name = "state", value = "自定义数据，长度限制：100 个字符，如果提交了该字段，会在上传完成回调时透传返回", required = false)
        private String state;
        
    }

}
