package net.polyv.vod.v1.entity.manage.list;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodPageCommonRequest;

/**
 * 查询视频列表请求实体
 * @author: fangyan
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询视频列表请求实体")
public class VodGetVideoListRequest extends VodPageCommonRequest {
    
    /**
     * 用户ID
     */
    @ApiModelProperty(hidden = true, name = "userId", value = "用户ID", required = true)
    @NotNull(message = "属性userId不能为空")
    @JSONField(name = "userid")
    private String userId;
    
    /**
     * 需要返回的视频信息，多个以英文逗号分隔，取值：basicInfo,metaData,transcodeInfo,snapshotInfo, 分别代表基础信息、元数据、转码信息、截图信息，默认仅返回基础信息
     */
    @ApiModelProperty(name = "filters", value = "需要返回的视频信息，多个以英文逗号分隔，取值：basicInfo,metaData,transcodeInfo," +
            "snapshotInfo, 分别代表基础信息、元数据、转码信息、截图信息，默认仅返回基础信息", required = false)
    private String filters;
    
    /**
     * 视频分类ID
     */
    @ApiModelProperty(name = "categoryId", value = "视频分类ID", required = false)
    @JSONField(name = "cateId")
    private String categoryId;
    
    /**
     * 按标题模糊搜索
     */
    @ApiModelProperty(name = "title", value = "按标题模糊搜索", required = false)
    private String title;
    
    /**
     * 按视频标签模糊搜索
     */
    @ApiModelProperty(name = "tag", value = "按视频标签模糊搜索", required = false)
    private String tag;
    
    /**
     * 上传者
     */
    @ApiModelProperty(name = "uploader", value = "上传者", required = false)
    private String uploader;
    
    /**
     * 视频状态,60/61已发布；10等待编码；20正在编码；50等待审核；51审核不通过；-1已删除；多个状态以英文逗号分隔，查询已发布状态的视频只需传61/60其中一个即可，如“61,60”
     */
    @ApiModelProperty(name = "status", value = "视频状态,60/61已发布；10等待编码；20正在编码；50等待审核；51审核不通过；-1" +
            "已删除；多个状态以英文逗号分隔，查询已发布状态的视频只需传61/60其中一个即可，如“61,50”", required = false)
    private String status;
    
    /**
     * 是否包含子分类, true：包含, false：不包含
     */
    @ApiModelProperty(name = "containSubCate", value = "是否包含子分类, true：包含, false：不包含", required = false)
    private Boolean containSubCate;
    
    /**
     * 开始时间，格式：yyyy-MM-dd HH:mm:ss
     */
    @ApiModelProperty(name = "startTime", value = "开始时间，格式：yyyy-MM-dd HH:mm:ss", required = false)
    private Date startTime;
    
    /**
     * 结束时间，格式：yyyy-MM-dd HH:mm:ss
     */
    @ApiModelProperty(name = "endTime", value = "结束时间，格式：yyyy-MM-dd HH:mm:ss", required = false)
    private Date endTime;
    
    /**
     * 是否加密
     */
    @ApiModelProperty(name = "encrypted", value = "是否加密", required = false)
    private Boolean encrypted;
    
    /**
     * 是否开启了播放授权
     */
    @ApiModelProperty(name = "playAuthEnable", value = "是否开启了播放授权", required = false)
    private Boolean playAuthEnable;
    
    /**
     * 结果排序，可以按创建时间或播放次数降序/升序排序，取值：creationTimeAsc（创建时间升序）、creationTimeDesc（创建时间降序）、playTimesAsc
     * （播放次数升序）、playTimesDesc（播放次数降序），默认按撞见时间升序排序
     */
    @ApiModelProperty(name = "sort", value = "结果排序，可以按创建时间或播放次数降序/升序排序，取值：creationTimeAsc（创建时间升序）、creationTimeDesc" +
            "（创建时间降序）、playTimesAsc（播放次数升序）、playTimesDesc（播放次数降序），默认按撞见时间升序排序", required = false)
    private String sort;
}
