/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.config;

import java.io.File;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.StringUtils;

public class UploadConfig {
    private int partitionSize = 0x100000;
    private String checkpoint = "checkpoint_lcoation";
    private int threadNum = 5;

    public UploadConfig() {
        this.checkArgument();
    }

    public UploadConfig(int partitionSize, String checkpoint, int threadNum) {
        this.partitionSize = partitionSize;
        this.checkpoint = checkpoint;
        this.threadNum = threadNum;
        this.checkArgument();
    }

    private void checkArgument() {
        if (StringUtils.isBlank((String)this.checkpoint)) {
            throw new PloyvSdkException(Constant.ERROR_CODE, "PolyvUploadClient\u4e2dcheckpoint\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        File checkpointFile = new File(this.checkpoint);
        if (!checkpointFile.exists() && !checkpointFile.mkdirs()) {
            throw new PloyvSdkException(Constant.ERROR_CODE, "PolyvUploadClient\u4e2dcheckpoint\u8def\u5f84\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u3002");
        }
        if (this.threadNum <= 0) {
            this.threadNum = 5;
        }
        if (this.partitionSize < 102400 || this.partitionSize > 0x40000000) {
            this.partitionSize = 102400;
        }
    }

    public int getPartitionSize() {
        return this.partitionSize;
    }

    public String getCheckpoint() {
        return this.checkpoint;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setPartitionSize(int partitionSize) {
        this.partitionSize = partitionSize;
    }

    public void setCheckpoint(String checkpoint) {
        this.checkpoint = checkpoint;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadConfig)) {
            return false;
        }
        UploadConfig other = (UploadConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPartitionSize() != other.getPartitionSize()) {
            return false;
        }
        if (this.getThreadNum() != other.getThreadNum()) {
            return false;
        }
        String this$checkpoint = this.getCheckpoint();
        String other$checkpoint = other.getCheckpoint();
        return !(this$checkpoint == null ? other$checkpoint != null : !this$checkpoint.equals(other$checkpoint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UploadConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartitionSize();
        result = result * 59 + this.getThreadNum();
        String $checkpoint = this.getCheckpoint();
        result = result * 59 + ($checkpoint == null ? 43 : $checkpoint.hashCode());
        return result;
    }

    public String toString() {
        return "UploadConfig(partitionSize=" + this.getPartitionSize() + ", checkpoint=" + this.getCheckpoint() + ", threadNum=" + this.getThreadNum() + ")";
    }
}

