package net.polyv.vod.v1.entity.upload.vo;

import lombok.Data;

/**
 * 阿里云上传OSS初始化返回token
 * @author: sadboy
 **/
@Data
public class VodUploadOSSTokenResponse {
    
    /**
     * 上传需要的accessId
     */
    private String accessId;
    
    /**
     * 上传需要的accessKey
     */
    private String accessKey;
    
    /**
     * 上传的桶名
     */
    private String bucketName;
    
    /**
     * 文件上传到对象存储的路径，如：uploadvideo/20220303/
     */
    private String dir;
    
    private String domain;
    
    /**
     * 对象存储的endpoint
     */
    private String endpoint;
    
    /**
     * token过期时间（时间点）
     */
    private String expiration;
    
    /**
     * 上传token
     */
    private String token;
    
    /**
     * token过期时间（时间段），如：3600
     */
    private long validityTime;
    
    /**
     * 华为云OBS上传信息
     */
    private VodUploadOBSTokenResponse hwObsInfo;
    
}
