package net.polyv.vod.v1.entity.play.payersettings;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodCommonRequest;

/**
 * 设置视频的播放器请求实体
 * @author: fangyan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("设置视频的播放器请求实体")
public class VodSetVideoPlayerRequest extends VodCommonRequest {
    
    /**
     * 用户ID
     */
    @ApiModelProperty(hidden = true, name = "userId", value = "用户ID", required = true)
    @NotNull(message = "属性userId不能为空")
    @JSONField(name = "userid")
    private String userId;
    
    /**
     * 视频ID
     */
    @ApiModelProperty(name = "videoId", value = "视频ID", required = true)
    @NotNull(message = "属性videoId不能为空")
    @JSONField(name = "vid")
    private String videoId;
    
    /**
     * 播放器ID
     */
    @ApiModelProperty(name = "playerId", value = "播放器ID", required = true)
    @NotNull(message = "属性playerId不能为空")
    private String playerId;
}
