package net.polyv.vod.v1.entity.play.payersettings;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 获取播放域名限制设置返回实体
 * @author: fangyan
 */
@Data
@Accessors(chain = true)
@ApiModel("获取播放域名限制设置返回实体")
public class VodGetPlayDomainResponse {
    /**
     * 用户ID
     */
    @ApiModelProperty(name = "userid", value = "用户ID", required = false)
    private String userid;
    
    /**
     * 限制类型，0：无域名限制，1：黑名单，2：白名单，3：白名单和黑名单复合限制
     */
    @ApiModelProperty(name = "settingType", value = "限制类型，0：无域名限制，1：黑名单，2：白名单，3：白名单和黑名单复合限制", required = false)
    private Integer settingType;
    
    /**
     * 禁止播放的域名（黑名单），多个域名以英文逗号分隔，在settingType = 1时有效
     */
    @ApiModelProperty(name = "disableHost", value = "禁止播放的域名（黑名单），多个域名以英文逗号分隔，在settingType = 1时有效", required = false)
    private String disableHost;
    
    /**
     * 可以播放的域名（白名单），多个域名以英文逗号分隔，在settingType = 2时有效
     */
    @ApiModelProperty(name = "enableHost", value = "可以播放的域名（白名单），多个域名以英文逗号分隔，在settingType = 2时有效", required = false)
    private String enableHost;
}
