package net.polyv.vod.v1.entity.play.list;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodCommonRequest;

/**
 * 将视频从播放列表移除请求实体
 * @author: fangyan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("将视频从播放列表移除请求实体")
public class VodRemoveVideoFromPlayListRequest extends VodCommonRequest {
    
    /**
     * 用户ID
     */
    @ApiModelProperty(hidden = true, name = "userId", value = "用户ID", required = true)
    @NotNull(message = "属性userId不能为空")
    @JSONField(name = "userid")
    private String userId;
    
    /**
     * 播放列表ID
     */
    @ApiModelProperty(name = "playListId", value = "播放列表ID", required = true)
    @NotNull(message = "属性playListId不能为空")
    private String playListId;
    
    /**
     * 视频ID
     */
    @ApiModelProperty(name = "videoId", value = "视频ID", required = true)
    @NotNull(message = "属性videoId不能为空")
    @JSONField(name = "vid")
    private String videoId;
}
