package net.polyv.vod.v1.entity.play.list;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.vod.v1.entity.VodPageCommonResponse;

/**
 * 获取播放列表信息返回实体
 * @author: fangyan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("获取播放列表信息返回实体")
public class VodGetPlayListInfoResponse extends VodPageCommonResponse {
    
    /**
     * 分页数据
     */
    @ApiModelProperty(name = "contents", value = "分页数据", required = false)
    private List<Content> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("分页数据")
    public static class Content {
        /**
         * 播放列表ID
         */
        @ApiModelProperty(name = "id", value = "播放列表ID", required = false)
        private Long id;
        
        /**
         * 播放列表描述信息
         */
        @ApiModelProperty(name = "description", value = "播放列表描述信息", required = false)
        private String description;
        
        /**
         * 播放列表标签
         */
        @ApiModelProperty(name = "tag", value = "播放列表标签", required = false)
        private String tag;
        
        /**
         * 播放列表标题
         */
        @ApiModelProperty(name = "title", value = "播放列表标题", required = false)
        private String title;
        
        /**
         * 播放列表创建时间，格式为yyyy-MM-dd HH:mm:ss
         */
        @ApiModelProperty(name = "creationTime", value = "播放列表创建时间，格式为yyyy-MM-dd HH:mm:ss", required = false)
        private Date creationTime;
        
        /**
         * 播放列表最近更新时间，格式为yyyy-MM-dd HH:mm:ss
         */
        @ApiModelProperty(name = "updateTime", value = "播放列表最近更新时间，格式为yyyy-MM-dd HH:mm:ss", required = false)
        private Date updateTime;
        
        /**
         * 播放列表的视频数量
         */
        @ApiModelProperty(name = "videoCount", value = "播放列表的视频数量", required = false)
        private Integer videoCount;
        
        /**
         * 播放列表的视频
         */
        @ApiModelProperty(name = "videoList", value = "播放列表的视频", required = false)
        private List<VideoList> videoList;
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("播放列表的视频")
    public static class VideoList {
        /**
         * 视频vid
         */
        @ApiModelProperty(name = "vid", value = "视频vid", required = false)
        private String vid;
        
        /**
         * 视频标题
         */
        @ApiModelProperty(name = "title", value = "视频标题", required = false)
        private String title;
        
        /**
         * 视频时长，单位：秒
         */
        @ApiModelProperty(name = "duration", value = "视频时长，单位：秒", required = false)
        private Float duration;
        
        /**
         * 视频首图url
         */
        @ApiModelProperty(name = "coverURL", value = "视频首图url", required = false)
        private String coverURL;
    }
}
