package net.polyv.vod.v1.entity.manage.info;

import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 获取单个视频的问答题目返回实体
 * @author: fangyan
 **/
@Data
@Accessors(chain = true)
@ApiModel("获取单个视频的问答题目返回实体")
public class VodQueryVideoExamResponse {
    /**
     * 问答列表
     */
    @ApiModelProperty(name = "exams", value = "问答列表", required = false)
    private List<Exam> exams;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("问答")
    public static class Exam {
        /**
         * 视频ID
         */
        @ApiModelProperty(name = "videoId", value = "视频ID", required = false)
        @JSONField(name = "vid")
        private String videoId;
        
        /**
         * 问答ID
         */
        @ApiModelProperty(name = "examId", value = "问答ID", required = false)
        private String examId;
        
        /**
         * 问答出现的时间，单位：秒
         */
        @ApiModelProperty(name = "showTime", value = "问答出现的时间，单位：秒", required = false)
        private Integer showTime;
        
        /**
         * 问答题目描述
         */
        @ApiModelProperty(name = "question", value = "问答题目描述", required = false)
        private String question;
        
        /**
         * 问答选项json数组，每个题目最多5个选项
         */
        @ApiModelProperty(name = "choices", value = "问答选项json数组，每个题目最多5个选项", required = false)
        private String choices;
        
        /**
         * 是否可跳过，默认值：false
         */
        @ApiModelProperty(name = "canSkip", value = "是否可跳过，默认值：false", required = false)
        private Boolean canSkip;
        
        /**
         * 回答正确后的解答详情
         */
        @ApiModelProperty(name = "explanationIfRight", value = "回答正确后的解答详情", required = false)
        private String explanationIfRight;
        
        /**
         * 回答答错误后是否显示解答详情
         */
        @ApiModelProperty(name = "showExplanationIfWrong", value = "回答答错误后是否显示解答详情", required = false)
        private Boolean showExplanationIfWrong;
        
        /**
         * 回答错误后的解答详情
         */
        @ApiModelProperty(name = "explanationIfWrong", value = "回答错误后的解答详情", required = false)
        private String explanationIfWrong;
        
        /**
         * 答错后回退到第几秒，-1代表不回退，默认为-1
         */
        @ApiModelProperty(name = "backTime", value = "答错后回退到第几秒，-1代表不回退，默认为-1", required = false)
        private Integer backTime;
        
        /**
         * 是否有效，1：有效，0：无效，默认为1
         */
        @ApiModelProperty(name = "status", value = "是否有效，1：有效，0：无效，默认为1", required = false)
        private Integer status;
        
        /**
         * 题目类型，0：选择题，1：听力题（听力题即将下线）
         */
        @ApiModelProperty(name = "type", value = "题目类型，0：选择题，1：听力题（听力题即将下线）", required = false)
        private Integer type;
        
        /**
         * 听力题的mp3音频文件url（听力题即将下线）
         */
        @ApiModelProperty(name = "mp3url", value = "听力题的mp3音频文件url（听力题即将下线）", required = false)
        private String mp3url;
        
        /**
         * 问答图片url
         */
        @ApiModelProperty(name = "illustration", value = "问答图片url", required = false)
        private String illustration;
    }
}
