package net.polyv.vod.v1.entity.datastatistics;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询视频统计汇总数据响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询视频统计汇总数据响应实体")
public class VodGetVideoSummaryDataResponse {
    /**
     * 视频id
     */
    @ApiModelProperty(name = "videoId", value = "视频id", required = false)
    private String videoId;
    
    /**
     * pc端播放量
     */
    @ApiModelProperty(name = "pcVideoView", value = "pc端播放量", required = false)
    private String pcVideoView;
    
    /**
     * 移动端播放量
     */
    @ApiModelProperty(name = "mobileVideoView", value = "移动端播放量", required = false)
    private String mobileVideoView;
    
    /**
     * pc端唯一观众量
     */
    @ApiModelProperty(name = "pcUniqueViewer", value = "pc端唯一观众量", required = false)
    private String pcUniqueViewer;
    
    /**
     * 移动端唯一观众量
     */
    @ApiModelProperty(name = "mobileUniqueViewer", value = "移动端唯一观众量", required = false)
    private String mobileUniqueViewer;
    
    /**
     * pc端消耗流量，单位：字节
     */
    @ApiModelProperty(name = "pcFlowSize", value = "pc端消耗流量，单位：字节", required = false)
    private Long pcFlowSize;
    
    /**
     * 移动端消耗流量，单位：字节
     */
    @ApiModelProperty(name = "mobileFlowSize", value = "移动端消耗流量，单位：字节", required = false)
    private Long mobileFlowSize;
    
}