package net.polyv.vod.v1.entity.datastatistics;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodCommonRequest;

/**
 * 查询视频统计汇总数据请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询视频统计汇总数据请求实体")
public class VodGetVideoSummaryDataRequest extends VodCommonRequest {
    
    /**
     * userId
     */
    @ApiModelProperty(hidden = true, required = true)
    @NotNull(message = "属性userId不能为空")
    @JSONField(name = "userid")
    private String userId;
    
    /**
     * 视频id，多个视频以英文逗号分隔，例如：a2dc4f25179499d6586362672838cc2d_a,a2dc4f25179499d6586362672838cc2d_a 一次最多只能传100个视频id
     * 不传时则查整个账号的数据
     */
    @ApiModelProperty(name = "videoIds", value = "视频id，多个视频以英文逗号分隔，例如：a2dc4f25179499d6586362672838cc2d_a," +
            "a2dc4f25179499d6586362672838cc2d_a 一次最多只能传100个视频id 不传时则查整个账号的数据", required = false)
    @JSONField(name = "vids")
    private String videoIds;
    
    /**
     * 时间段，默认值为7days（7days包含今天） today：今天 yesterday：昨天 this_week：本周 last_week：上周 7days：最近7天 this_month：本月
     * last_month：上个月 this_year：今年 last_year：去年
     */
    @ApiModelProperty(name = "dr", value = "时间段，具体值为以下几个：today（今天），yesterday（昨天），this_week" +
            "（本周），last_week（上周），7days（最近7天），this_month（本月），last_month（上个月），this_year（今年），last_year（去年），默认值为7days:最近7" +
            "天（包含今天）", required = false)
    private String dr;
    
    /**
     * 开始日期，格式为：yyyy-MM-dd，例如：2021-03-01
     */
    @ApiModelProperty(name = "startTime", value = "开始日期，格式为：yyyy-MM-dd，例如：2021-03-01", required = false)
    @JSONField(name = "startDate", format = "yyyy-MM-dd")
    private Date startTime;
    
    /**
     * 结束日期，格式为：yyyy-MM-dd，例如：2021-03-30，跨度最大为一年，可跨年查询
     */
    @ApiModelProperty(name = "endTime", value = "结束日期，格式为：yyyy-MM-dd，例如：2021-03-30，跨度最大为一年，可跨年查询", required = false)
    @JSONField(name = "endDate", format = "yyyy-MM-dd")
    private Date endTime;
    
}