package net.polyv.vod.v1.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.Max;
import net.polyv.common.v1.validator.constraints.Min;

/**
 * 点播分页公共请求实体
 * @author: sadboy
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class VodPageTokenCommonRequest extends VodCommonRequest {
    
    /**
     * 下一页的凭证，从当前页的返回数据里获取，第一页不需要传
     */
    @ApiModelProperty(name = "token", value = "下一页的凭证，从当前页的返回数据里获取，第一页不需要传", required = false)
    private String token;
    
    /**
     * 每页取多少条数据(最大为20，超过则默认取20条数据)
     */
    @ApiModelProperty(name = "pageSize", value = "每页显示的数据条数，默认每页显示20条数据", dataType = "Integer", example = "12")
    @Max(value = 20, message = "每页显示的数据条数不能超过20")
    @Min(value = 0, message = "每页显示的数据条数不能小于0")
    private Integer pageSize = 20;
    
}
