/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.upload.service.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.event.ProgressEvent;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.model.Callback;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.UploadFileRequest;
import net.polyv.common.v1.base.HttpClientUtil;
import net.polyv.common.v1.util.FileUtil;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.vod.v1.config.UploadConfig;
import net.polyv.vod.v1.entity.upload.vo.VodUploadConfigResponse;
import net.polyv.vod.v1.entity.upload.vo.VodUploadOSSTokenResponse;
import net.polyv.vod.v1.entity.upload.vo.VodUploadVideoConfigRequest;
import net.polyv.vod.v1.upload.callback.UploadCallBack;
import net.polyv.vod.v1.upload.enumeration.UploadErrorMsg;
import net.polyv.vod.v1.upload.provide.PolyvCredentialProvider;
import net.polyv.vod.v1.upload.service.VodOSSService;
import net.polyv.vod.v1.upload.service.VodUploadVideoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliOSSService
implements VodOSSService {
    private static final Logger log = LoggerFactory.getLogger(AliOSSService.class);
    private VodUploadConfigResponse vodUploadVideoConfigResponse;
    private UploadConfig uploadConfig;
    private VodUploadVideoConfigRequest vodUploadVideoConfigRequest;

    private AliOSSService() {
    }

    public AliOSSService(VodUploadConfigResponse vodUploadVideoConfigResponse, UploadConfig uploadConfig, VodUploadVideoConfigRequest vodUploadVideoConfigRequest) {
        this.uploadConfig = uploadConfig;
        this.vodUploadVideoConfigResponse = vodUploadVideoConfigResponse;
        this.vodUploadVideoConfigRequest = vodUploadVideoConfigRequest;
    }

    @Override
    public boolean upload(final UploadCallBack eventCallBack, final boolean printProcessLog) {
        VodUploadOSSTokenResponse uploadToken = this.getUploadToken();
        String bucketName = uploadToken.getBucketName();
        int taskNum = this.uploadConfig.getThreadNum();
        final String vId = this.vodUploadVideoConfigResponse.getVid();
        String objectName = uploadToken.getDir() + vId + "." + FileUtil.getExtension(this.vodUploadVideoConfigRequest.getFile().getPath());
        String fileLocation = this.vodUploadVideoConfigRequest.getFile().getPath();
        String checkpointFile = this.uploadConfig.getCheckpoint() + "/" + vId + ".ucp";
        OSS ossClient = this.buildOssClient(uploadToken);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentType("text/plain");
        UploadFileRequest uploadFileRequest = new UploadFileRequest(bucketName, objectName);
        uploadFileRequest.setUploadFile(fileLocation);
        uploadFileRequest.setTaskNum(taskNum);
        uploadFileRequest.setPartSize(this.uploadConfig.getPartitionSize());
        uploadFileRequest.setEnableCheckpoint(true);
        uploadFileRequest.setCheckpointFile(checkpointFile);
        uploadFileRequest.setObjectMetadata(meta);
        Callback callback = JSON.parseObject(this.vodUploadVideoConfigResponse.getCallback(), Callback.class);
        uploadFileRequest.setCallback(callback);
        uploadFileRequest.setProgressListener(new ProgressListener(){
            private long bytesWritten = 0L;
            private long totalBytes = -1L;
            private long totalFileSize = AliOSSService.access$000(AliOSSService.this).getFileSize();

            @Override
            public void progressChanged(ProgressEvent progressEvent) {
                long bytes = progressEvent.getBytes();
                ProgressEventType eventType = progressEvent.getEventType();
                String videoPoolId = vId;
                switch (eventType) {
                    case TRANSFER_STARTED_EVENT: {
                        eventCallBack.start(videoPoolId);
                        if (!printProcessLog) break;
                        log.info("\u3010{}\u3011vid={}, Start to upload......", (Object)AliOSSService.this.vodUploadVideoConfigRequest.getTitle(), (Object)videoPoolId);
                        log.info("\u3010{}\u3011File size is {} bytes", (Object)videoPoolId, (Object)this.totalFileSize);
                        break;
                    }
                    case REQUEST_CONTENT_LENGTH_EVENT: {
                        this.totalBytes = bytes;
                        if (!printProcessLog) break;
                        log.info("\u3010{}\u3011{} bytes in total will be uploaded to Server", (Object)videoPoolId, (Object)this.totalBytes);
                        break;
                    }
                    case REQUEST_BYTE_TRANSFER_EVENT: {
                        this.bytesWritten += bytes;
                        eventCallBack.process(videoPoolId, this.totalFileSize - this.totalBytes + this.bytesWritten, this.totalFileSize);
                        if (!printProcessLog) break;
                        if (this.totalBytes != -1L) {
                            int percent = (int)((double)(this.totalFileSize - this.totalBytes + this.bytesWritten) * 100.0 / (double)this.totalFileSize);
                            log.info("\u3010{}\u3011{} bytes have been written at this time, upload progress: {}%({}/{})", videoPoolId, bytes, percent, this.totalFileSize - this.totalBytes + this.bytesWritten, this.totalFileSize);
                            break;
                        }
                        log.info("\u3010{}\u3011{} bytes have been written at this time, upload ratio: unknown({}/...)", videoPoolId, bytes, this.totalFileSize - this.totalBytes + this.bytesWritten);
                        break;
                    }
                    case TRANSFER_COMPLETED_EVENT: {
                        eventCallBack.complete(videoPoolId);
                        if (!printProcessLog) break;
                        log.info("\u3010{}\u3011Succeed to upload, {} bytes have been transferred in total", (Object)videoPoolId, (Object)(this.totalFileSize - this.totalBytes + this.bytesWritten));
                        break;
                    }
                    case TRANSFER_FAILED_EVENT: {
                        eventCallBack.error(videoPoolId, UploadErrorMsg.ERROR_UPLOAD_PART);
                        if (!printProcessLog) break;
                        log.info("\u3010{}\u3011Failed to upload, {} bytes have been transferred", (Object)videoPoolId, (Object)(this.totalFileSize - this.totalBytes + this.bytesWritten));
                        break;
                    }
                }
            }
        });
        return this.triggerUpload(vId, ossClient, uploadFileRequest, eventCallBack);
    }

    private boolean triggerUpload(String videoPoolId, OSS ossClient, UploadFileRequest uploadFileRequest, UploadCallBack eventCallBack) {
        try {
            ossClient.uploadFile(uploadFileRequest);
            ossClient.shutdown();
            eventCallBack.success(videoPoolId);
            return true;
        }
        catch (OSSException e) {
            if ("InvalidAccessKeyId".equals(e.getErrorCode()) || "SecurityTokenExpired".equals(e.getErrorCode())) {
                log.info("token is expired. reupload the video. requestId={}", (Object)e.getRequestId());
                ossClient = this.buildOssClient(null);
                return this.triggerUpload(videoPoolId, ossClient, uploadFileRequest, eventCallBack);
            }
            log.error(e.getMessage(), e);
            eventCallBack.error(videoPoolId, UploadErrorMsg.ERROR_UPLOAD_TOKEN_EXPIRE);
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage(), throwable);
            eventCallBack.error(videoPoolId, UploadErrorMsg.ERROR_UPLOAD_EXCEPTION);
        }
        ossClient.shutdown();
        return false;
    }

    private OSS buildOssClient(VodUploadOSSTokenResponse uploadToken) {
        uploadToken = uploadToken == null ? this.getUploadToken() : uploadToken;
        String accessKeyId = uploadToken.getAccessId();
        String accessKeySecret = uploadToken.getAccessKey();
        String securityToken = uploadToken.getToken();
        String domain = uploadToken.getDomain();
        long validityTime = uploadToken.getValidityTime() * 1000L;
        ClientBuilderConfiguration ossConfig = new ClientBuilderConfiguration();
        ossConfig.setSupportCname(true);
        String proxyHostName = HttpClientUtil.getProxyHostName();
        if (StringUtils.isNotBlank(proxyHostName)) {
            ossConfig.setProxyHost(proxyHostName);
            ossConfig.setProxyPort(HttpClientUtil.getProxyPort());
        }
        return new OSSClient(domain, new PolyvCredentialProvider(accessKeyId, accessKeySecret, securityToken, System.currentTimeMillis() + validityTime), ossConfig);
    }

    private VodUploadOSSTokenResponse getUploadToken() {
        return new VodUploadVideoService().getUploadToken(3);
    }
}

