/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

public enum HttpMethodEnum {
    GET("Get"),
    PUT("Put"),
    POST("Post"),
    DELETE("Delete"),
    HEAD("Head"),
    OPTIONS("Options");

    private String operationType;

    private HttpMethodEnum(String operationType) {
        if (operationType == null) {
            throw new IllegalArgumentException("operation type code is null");
        }
        this.operationType = operationType;
    }

    public String getOperationType() {
        return this.operationType.toUpperCase();
    }

    public static HttpMethodEnum getValueFromStringCode(String operationType) {
        if (operationType == null) {
            throw new IllegalArgumentException("operation type is null");
        }
        for (HttpMethodEnum installMode : HttpMethodEnum.values()) {
            if (!installMode.getOperationType().equals(operationType.toUpperCase())) continue;
            return installMode;
        }
        throw new IllegalArgumentException("operation type is illegal");
    }
}

