package net.polyv.vod.v1.entity.subaccount;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.vod.v1.entity.VodPageCommonResponse;

/**
 * 查询子账号统计汇总数据返回实体
 * @author: jiangyifan
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel("查询子账号统计汇总数据返回实体")
public class VodSubAccountStatsAggPageResponse extends VodPageCommonResponse {
    
    @ApiModelProperty(name = "contents", value = "查询的结果列表", required = false)
    private List<VodSubAccountStatsAggPageResponse.VodContentsList> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("查询的结果列表")
    public static class VodContentsList {
        
        /**
         * 子账号邮箱
         */
        @ApiModelProperty(name = "email", value = "子账号邮箱，如果子账号被删除，则该字段为null", required = false)
        private String email;
        
        /**
         * 子账号appId
         */
        @ApiModelProperty(name = "appId", value = "子账号appId", required = false)
        private String appId;
        
        /**
         * 源文件大小，单位：byte
         */
        @ApiModelProperty(name = "flowSize", value = "源文件大小，单位：byte", required = false)
        private Long flowSize;
        
        /**
         * 播放量，单位：个
         */
        @ApiModelProperty(name = "view", value = "播放量，单位：个", required = false)
        private Long view;
        
        /**
         * 播放时长，单位：秒
         */
        @ApiModelProperty(name = "duration", value = "播放时长，单位：秒", required = false)
        private Long duration;
    }
}
