package net.polyv.vod.v1.entity.manage.edit;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodCommonRequest;

/**
 * 删除单个视频的问答题目请求实体
 * @author: sadboy
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("删除单个视频的问答题目请求实体")
public class VodRemoveVideoExamRequest extends VodCommonRequest {
    
    /**
     * 用户ID
     */
    @ApiModelProperty(name = "userId", value = "用户ID", required = false)
    @JSONField(name = "userid")
    private String userId;
    
    /**
     * 视频ID
     */
    @ApiModelProperty(name = "videoId", value = "视频ID", required = true)
    @NotNull(message = "属性videoId不能为空")
    @JSONField(name = "vid")
    private String videoId;
    
    /**
     * 问答ID，多个以英文逗号分隔，如果不传则删除视频的所有问答题目。例如 17982289509,17982289508
     */
    @ApiModelProperty(name = "examIds", value = "问答ID，多个以英文逗号分隔，如果不传则删除视频的所有问答题目。例如 17982289509,17982289508",
            required = false)
    private String examIds;
}
