package net.polyv.vod.v1.constant;

/**
 * @author: thomas
 **/
public class VodConstant {
    
    /**
     * 日期区间
     * today：今天
     * yesterday：昨天
     * this_week：本周
     * last_week：上周
     * 7days：最近7天
     * this_month：本月
     * last_month：上个月
     * this_year：今年
     * last_year：去年
     */
    public enum DateRange {
        
        /**
         * 今天
         */
        DR_TODAY("today"),
        
        /**
         * 昨天
         */
        DR_YESTERDAY("yesterday"),
        
        /**
         * 本周
         */
        DR_THIS_WEEK("this_week"),
        
        /**
         * 上周
         */
        DR_LAST_WEEK("last_week"),
        
        /**
         * 最近七天
         */
        DR_7DAYS("7days"),
        
        /**
         * 本月
         */
        DR_THIS_MONTH("this_month"),
        
        /**
         * 上月
         */
        DR_LAST_MONTH("last_month"),
        
        /**
         * 几年
         */
        DR_THIS_YEAR("this_year"),
        
        /**
         * 去年
         */
        DR_LAST_YEAR("last_year");
        
        private final String range;
        
        DateRange(String range) {
            this.range = range;
        }
        
        public String getValue() {
            return range;
        }
    }
}
