/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.upload.client;

import java.util.List;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.entity.CommonReqeust;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.SDKValidateUtil;
import net.polyv.common.v1.validator.ViolationMsg;
import net.polyv.vod.v1.config.UploadConfig;
import net.polyv.vod.v1.entity.upload.VodUploadVideoPartsRequest;
import net.polyv.vod.v1.entity.upload.VodUploadVideoRequest;
import net.polyv.vod.v1.entity.upload.vo.VodUploadConfigResponse;
import net.polyv.vod.v1.entity.upload.vo.VodUploadVideoConfigRequest;
import net.polyv.vod.v1.upload.service.VodOSSService;
import net.polyv.vod.v1.upload.service.VodUploadVideoService;
import net.polyv.vod.v1.upload.service.impl.AliOSSService;
import net.polyv.vod.v1.upload.service.impl.HuaWeiOBSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyvUploadClient {
    private static final Logger log = LoggerFactory.getLogger(PolyvUploadClient.class);
    public static final int RETRY_TIME = 3;
    private UploadConfig uploadConfig;

    public PolyvUploadClient() {
        this.uploadConfig = new UploadConfig();
    }

    public PolyvUploadClient(int partitionSize, String checkpoint, int threadNum) {
        this.uploadConfig = new UploadConfig(partitionSize, checkpoint, threadNum);
    }

    public VodOSSService buildOSSService(CommonReqeust commonRequest) {
        VodUploadVideoConfigRequest vodUploadVideoConfigRequest = null;
        if (commonRequest instanceof VodUploadVideoRequest) {
            VodUploadVideoRequest vodUploadVideoRequest = (VodUploadVideoRequest)commonRequest;
            this.validateBean(vodUploadVideoRequest);
            vodUploadVideoConfigRequest = new VodUploadVideoConfigRequest(vodUploadVideoRequest);
        } else if (commonRequest instanceof VodUploadVideoPartsRequest) {
            VodUploadVideoPartsRequest vodUploadVideoPartsRequest = (VodUploadVideoPartsRequest)commonRequest;
            this.validateBean(vodUploadVideoPartsRequest);
            vodUploadVideoConfigRequest = new VodUploadVideoConfigRequest(vodUploadVideoPartsRequest);
        } else {
            throw new PloyvSdkException(Constant.ERROR_CODE, "\u70b9\u64ad\u4e0a\u4f20\u89c6\u9891\u5bf9\u8c61\u5f02\u5e38");
        }
        VodUploadConfigResponse vodUploadConfigResponse = new VodUploadVideoService().initUploadQueue(vodUploadVideoConfigRequest, 3);
        if (vodUploadConfigResponse.getHwObsInfo() != null) {
            return new HuaWeiOBSService(vodUploadConfigResponse, this.uploadConfig, vodUploadVideoConfigRequest);
        }
        return new AliOSSService(vodUploadConfigResponse, this.uploadConfig, vodUploadVideoConfigRequest);
    }

    private <E extends CommonReqeust> void validateBean(E e) {
        List<ViolationMsg> violationMsgList = SDKValidateUtil.validateBean(e, new Class[0]);
        if (!violationMsgList.isEmpty()) {
            String errors = SDKValidateUtil.getViolationMsgStr(violationMsgList);
            errors = errors.substring(0, errors.length() - 3);
            errors = "\u8f93\u5165\u53c2\u6570 [" + e.getClass().getName() + "]\u5bf9\u8c61\u6821\u9a8c\u5931\u8d25 ,\u5931\u8d25\u5b57\u6bb5 [" + errors + "]";
            throw new PloyvSdkException(Constant.ERROR_CODE, errors);
        }
    }
}

