/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.auth;

import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.InstanceProfileCredentials;
import com.aliyun.oss.common.auth.InstanceProfileCredentialsFetcher;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyuncs.exceptions.ClientException;

public class InstanceProfileCredentialsProvider
implements CredentialsProvider {
    private final String roleName;
    private InstanceProfileCredentials credentials;
    private InstanceProfileCredentialsFetcher fetcher;
    private int maxRetryTimes = 3;

    public InstanceProfileCredentialsProvider(String roleName) {
        if (null == roleName) {
            throw new NullPointerException("You must specifiy a valid role name.");
        }
        this.roleName = roleName;
        this.fetcher = new InstanceProfileCredentialsFetcher();
        this.fetcher.setRoleName(this.roleName);
    }

    public InstanceProfileCredentialsProvider withCredentialsFetcher(InstanceProfileCredentialsFetcher fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    @Override
    public void setCredentials(Credentials creds) {
    }

    @Override
    public InstanceProfileCredentials getCredentials() {
        if (this.credentials == null || this.credentials.isExpired()) {
            try {
                this.credentials = (InstanceProfileCredentials)this.fetcher.fetch(this.maxRetryTimes);
            }
            catch (ClientException e) {
                LogUtils.logException("EcsInstanceCredentialsFetcher.fetch Exception:", e);
                return null;
            }
        }
        if (this.credentials.willSoonExpire() && this.credentials.shouldRefresh()) {
            try {
                this.credentials = (InstanceProfileCredentials)this.fetcher.fetch();
            }
            catch (ClientException e) {
                this.credentials.setLastFailedRefreshTime();
                LogUtils.logException("EcsInstanceCredentialsFetcher.fetch Exception:", e);
            }
        }
        return this.credentials;
    }
}

