/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.upload.service.impl;

import com.aliyun.oss.ClientBuilderConfiguration;
import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import com.obs.services.exception.ObsException;
import com.obs.services.model.Callback;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ProgressListener;
import com.obs.services.model.ProgressStatus;
import com.obs.services.model.UploadFileRequest;
import net.polyv.common.v1.util.FileUtil;
import net.polyv.vod.v1.config.UploadConfig;
import net.polyv.vod.v1.entity.upload.vo.VodUploadConfigResponse;
import net.polyv.vod.v1.entity.upload.vo.VodUploadOBSTokenResponse;
import net.polyv.vod.v1.entity.upload.vo.VodUploadOSSTokenResponse;
import net.polyv.vod.v1.entity.upload.vo.VodUploadVideoConfigRequest;
import net.polyv.vod.v1.upload.callback.UploadCallBack;
import net.polyv.vod.v1.upload.enumeration.UploadErrorMsg;
import net.polyv.vod.v1.upload.service.VodOSSService;
import net.polyv.vod.v1.upload.service.VodUploadVideoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaWeiOBSService
implements VodOSSService {
    private static final Logger log = LoggerFactory.getLogger(HuaWeiOBSService.class);
    private static final long NOTICE_UPLOAD_SIZE = 0x100000L;
    private VodUploadConfigResponse vodUploadVideoConfigResponse;
    private UploadConfig uploadConfig;
    private VodUploadVideoConfigRequest vodUploadVideoConfigRequest;

    private HuaWeiOBSService() {
    }

    public HuaWeiOBSService(VodUploadConfigResponse vodUploadVideoConfigResponse, UploadConfig uploadConfig, VodUploadVideoConfigRequest vodUploadVideoConfigRequest) {
        this.vodUploadVideoConfigResponse = vodUploadVideoConfigResponse;
        this.uploadConfig = uploadConfig;
        this.vodUploadVideoConfigRequest = vodUploadVideoConfigRequest;
    }

    @Override
    public boolean upload(final UploadCallBack callBack, final boolean printProcessLog) {
        VodUploadOBSTokenResponse uploadToken = this.vodUploadVideoConfigResponse.getHwObsInfo();
        String checkpoint = this.uploadConfig.getCheckpoint();
        int taskNum = this.uploadConfig.getThreadNum();
        int partitionSize = this.uploadConfig.getPartitionSize();
        final String vId = this.vodUploadVideoConfigResponse.getVid();
        String objectName = uploadToken.getDir() + vId + "." + FileUtil.getExtension((String)this.vodUploadVideoConfigRequest.getFile().getPath());
        String fileLocation = this.vodUploadVideoConfigRequest.getFile().getPath();
        String checkpointFile = checkpoint + "/" + vId + ".ucp";
        ObsClient obsClient = this.buildObsClient(uploadToken);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentType("text/plain");
        UploadFileRequest uploadFileRequest = new UploadFileRequest(uploadToken.getBucketName(), objectName);
        uploadFileRequest.setUploadFile(fileLocation);
        uploadFileRequest.setTaskNum(taskNum);
        uploadFileRequest.setPartSize((long)partitionSize);
        uploadFileRequest.setEnableCheckpoint(true);
        Callback callback = new Callback();
        callback.setCallbackUrl(uploadToken.getCallbackUrl());
        callback.setCallbackBody(uploadToken.getCallbackBody());
        callback.setCallbackBodyType(uploadToken.getCallbackBodyType());
        uploadFileRequest.setCallback(callback);
        uploadFileRequest.setCheckpointFile(checkpointFile);
        uploadFileRequest.setProgressInterval(0x100000L);
        uploadFileRequest.setEnableCheckSum(true);
        uploadFileRequest.setObjectMetadata(meta);
        uploadFileRequest.setProgressListener(new ProgressListener(){
            private boolean start = false;
            private long totalFileSize = HuaWeiOBSService.access$000(HuaWeiOBSService.this).getFileSize();

            public void progressChanged(ProgressStatus status) {
                String videoPoolId = vId;
                if (!this.start) {
                    this.start = true;
                    callBack.start(videoPoolId);
                    if (!printProcessLog) {
                        return;
                    }
                    log.info("\u3010{}\u3011vid={}, Start to upload......", (Object)HuaWeiOBSService.this.vodUploadVideoConfigRequest.getTitle(), (Object)videoPoolId);
                    log.info("\u3010{}\u3011File size is {} bytes", (Object)videoPoolId, (Object)this.totalFileSize);
                } else {
                    callBack.process(videoPoolId, status.getTransferredBytes(), status.getTotalBytes());
                }
            }
        });
        return this.triggerUpload(vId, obsClient, uploadFileRequest, callBack);
    }

    private boolean triggerUpload(String videoPoolId, ObsClient obsClient, UploadFileRequest uploadFileRequest, UploadCallBack eventCallBack) {
        try {
            CompleteMultipartUploadResult uploadResult = obsClient.uploadFile(uploadFileRequest);
            if (uploadResult.getStatusCode() == 200) {
                eventCallBack.success(videoPoolId);
                return true;
            }
            log.error("huawei upload return error\uff0cerror status code is\uff1a{}\uff0crequestId\uff1a{}", (Object)uploadResult.getStatusCode(), (Object)uploadResult.getRequestId());
            eventCallBack.error(videoPoolId, UploadErrorMsg.ERROR_UPLOAD_EXCEPTION);
            return false;
        }
        catch (ObsException e) {
            block7: {
                String errorCode = e.getErrorCode();
                if (!"InvalidAccessKeyId".equals(errorCode) || "SecurityTokenExpired".equals(errorCode)) {
                    try {
                        obsClient.listObjects(uploadFileRequest.getBucketName());
                    }
                    catch (ObsException exception) {
                        errorCode = exception.getErrorCode();
                        if ("InvalidAccessKeyId".equals(errorCode) && !"SecurityTokenExpired".equals(errorCode)) break block7;
                        eventCallBack.error(videoPoolId, UploadErrorMsg.ERROR_UPLOAD_TOKEN_EXPIRE);
                        return false;
                    }
                }
            }
            log.info("token is expired. reupload the video. requestId={}", (Object)e.getErrorRequestId());
            obsClient = this.refreshObsClient(obsClient);
            return this.triggerUpload(videoPoolId, obsClient, uploadFileRequest, eventCallBack);
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage(), throwable);
            eventCallBack.error(videoPoolId, UploadErrorMsg.ERROR_UPLOAD_EXCEPTION);
            return false;
        }
    }

    private ObsClient buildObsClient(VodUploadOBSTokenResponse uploadToken) {
        uploadToken = uploadToken == null ? this.getUploadToken() : uploadToken;
        String ak = uploadToken.getAk();
        String sk = uploadToken.getSk();
        String st = uploadToken.getSecuritytoken();
        String endPoint = uploadToken.getEndpoint();
        ClientBuilderConfiguration ossConfig = new ClientBuilderConfiguration();
        ossConfig.setSupportCname(true);
        ObsConfiguration obsConfiguration = new ObsConfiguration();
        obsConfiguration.setCname(true);
        obsConfiguration.setEndPoint("https://" + endPoint);
        return new ObsClient(ak, sk, st, "https://" + endPoint);
    }

    private ObsClient refreshObsClient(ObsClient obsClient) {
        VodUploadOBSTokenResponse uploadToken = this.getUploadToken();
        String ak = uploadToken.getAk();
        String sk = uploadToken.getSk();
        String st = uploadToken.getSecuritytoken();
        obsClient.refresh(ak, sk, st);
        return obsClient;
    }

    private VodUploadOBSTokenResponse getUploadToken() {
        VodUploadOSSTokenResponse uploadToken = new VodUploadVideoService().getUploadToken(3);
        return uploadToken.getHwObsInfo();
    }
}

