package net.polyv.vod.v1.service.play;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import net.polyv.vod.v1.entity.play.list.VodAddVideoToPlayListRequest;
import net.polyv.vod.v1.entity.play.list.VodCreatePlayListRequest;
import net.polyv.vod.v1.entity.play.list.VodCreatePlayListResponse;
import net.polyv.vod.v1.entity.play.list.VodGetOnePlayListRequest;
import net.polyv.vod.v1.entity.play.list.VodGetOnePlayListResponse;
import net.polyv.vod.v1.entity.play.list.VodGetPlayListInfoRequest;
import net.polyv.vod.v1.entity.play.list.VodGetPlayListInfoResponse;
import net.polyv.vod.v1.entity.play.list.VodRemoveVideoFromPlayListRequest;
import net.polyv.vod.v1.entity.play.list.VodUpdatePlayListRequest;
import net.polyv.vod.v1.entity.play.list.VodUpdatePlayListResponse;

/**
 * 播放列表
 * @author: fangyan
 */
public interface IVodPlayListService {
    /**
     * 获取单个播放列表
     * API地址：https://dev.polyv.net/2017/videoproduct/v-api/v-api-play/v-api-play-playlist/play-list/
     * @param vodGetOnePlayListRequest 获取单个播放列表请求实体
     * @return 获取单个播放列表返回实体列表
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<VodGetOnePlayListResponse> getOnePlayList(VodGetOnePlayListRequest vodGetOnePlayListRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 获取播放列表信息
     * @param vodGetPlayListInfoRequest 获取播放列表信息请求实体
     * @return 获取播放列表信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    VodGetPlayListInfoResponse getPlayListInfo(VodGetPlayListInfoRequest vodGetPlayListInfoRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 创建播放列表
     * API地址：https://dev.polyv.net/2021/uncategorized/create-play-list/
     * @param vodCreatePlayListRequest 创建播放列表请求实体
     * @return 创建播放列表返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    VodCreatePlayListResponse createPlayList(VodCreatePlayListRequest vodCreatePlayListRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改播放列表信息
     * API地址：https://dev.polyv.net/2021/uncategorized/update-play-list/
     * @param vodUpdatePlayListRequest 修改播放列表信息请求实体
     * @return 修改播放列表信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    VodUpdatePlayListResponse updatePlayList(VodUpdatePlayListRequest vodUpdatePlayListRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 添加视频至播放列表
     * API地址：https://dev.polyv.net/2021/uncategorized/add-video-to-play-list/
     * @param vodAddVideoToPlayListRequest 添加视频至播放列表请求实体
     * @return Boolean
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean addVideoToPlayList(VodAddVideoToPlayListRequest vodAddVideoToPlayListRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 将视频从播放列表移除
     * API地址：https://dev.polyv.net/2021/uncategorized/remove-video-from-play-list/
     * @param vodRemoveVideoFromPlayListRequest 将视频从播放列表移除请求实体
     * @return Boolean
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean removeVideoFromPlayList(VodRemoveVideoFromPlayListRequest vodRemoveVideoFromPlayListRequest)
            throws IOException, NoSuchAlgorithmException;
}
