package net.polyv.vod.v1.entity.manage;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodCommonRequest;

/**
 * 删除视频打点信息请求实体
 * @author: fangyan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("删除视频打点信息请求实体")
public class VodDeleteVideoFrameRequest extends VodCommonRequest {
    /**
     * 用户id
     */
    @ApiModelProperty(hidden = true,name = "userId", value = "用户id", required = true)
    @NotNull(message = "属性userId不能为空")
    @JSONField(name = "userid")
    private String userId;
    
    /**
     * 视频id
     */
    @ApiModelProperty(name = "videoId", value = "视频id", required = true)
    @NotNull(message = "属性videoId不能为空")
    @JSONField(name = "vid")
    private String videoId;
    
    /**
     * 时间点，单位：秒，多个以英文逗号分隔，如"1,2", 如果不传则删除视频的所有打点信息
     */
    @ApiModelProperty(name = "timePoints", value = "时间点，单位：秒，多个以英文逗号分隔，如“1, 2”, 如果不传则删除视频的所有打点信息", required = false)
    private String timePoints;
}
