/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.upload.provide;

import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentials;
import com.aliyun.oss.common.auth.InvalidCredentialsException;
import net.polyv.vod.v1.entity.upload.vo.VodUploadVideoConfigResponse;
import net.polyv.vod.v1.upload.service.VodUploadVideoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyvCredentialProvider
implements CredentialsProvider {
    private static final Logger log = LoggerFactory.getLogger(PolyvCredentialProvider.class);
    private static final Logger logger = LoggerFactory.getLogger(PolyvCredentialProvider.class);
    private volatile long expireTime;
    private volatile Credentials creds;

    public PolyvCredentialProvider(Credentials creds) {
        this.setCredentials(creds);
    }

    public PolyvCredentialProvider(String accessKeyId, String secretAccessKey, String securityToken, long expireTime) {
        PolyvCredentialProvider.checkCredentials(accessKeyId, secretAccessKey);
        this.setCredentials(new DefaultCredentials(accessKeyId, secretAccessKey, securityToken));
        this.setExpireTime(expireTime);
    }

    @Override
    public synchronized void setCredentials(Credentials creds) {
        if (creds == null) {
            throw new InvalidCredentialsException("creds should not be null.");
        }
        PolyvCredentialProvider.checkCredentials(creds.getAccessKeyId(), creds.getSecretAccessKey());
        this.creds = creds;
    }

    @Override
    public synchronized Credentials getCredentials() {
        if (this.creds == null) {
            throw new InvalidCredentialsException("Invalid credentials");
        }
        if (this.expireTime - System.currentTimeMillis() < 60000L) {
            logger.error("the token has expired. expireTime={}, rebuild the credential.", (Object)this.expireTime);
            long currentTime = System.currentTimeMillis();
            VodUploadVideoConfigResponse result = null;
            result = new VodUploadVideoService().getUploadToken(3);
            this.setCredentials(new DefaultCredentials(result.getAccessId(), result.getAccessKey(), result.getToken()));
            this.setExpireTime(currentTime + result.getValidityTime() * 1000L);
        }
        return this.creds;
    }

    private static void checkCredentials(String accessKeyId, String secretAccessKey) {
        if (accessKeyId == null || accessKeyId.equals("")) {
            throw new InvalidCredentialsException("Access key id should not be null or empty.");
        }
        if (secretAccessKey == null || secretAccessKey.equals("")) {
            throw new InvalidCredentialsException("Secret access key should not be null or empty.");
        }
    }

    private synchronized void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }
}

