/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.upload.client;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.event.ProgressEvent;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.model.Callback;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.UploadFileRequest;
import java.io.File;
import java.util.List;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.entity.CommonReqeust;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.SDKValidateUtil;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.common.v1.validator.ViolationMsg;
import net.polyv.vod.v1.entity.upload.VodUploadVideoPartsRequest;
import net.polyv.vod.v1.entity.upload.VodUploadVideoRequest;
import net.polyv.vod.v1.entity.upload.vo.VodUploadVideoConfigRequest;
import net.polyv.vod.v1.entity.upload.vo.VodUploadVideoConfigResponse;
import net.polyv.vod.v1.upload.callback.UploadCallBack;
import net.polyv.vod.v1.upload.enumeration.UploadErrorMsg;
import net.polyv.vod.v1.upload.provide.PolyvCredentialProvider;
import net.polyv.vod.v1.upload.service.VodUploadVideoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyvUploadClient {
    private static final Logger log = LoggerFactory.getLogger(PolyvUploadClient.class);
    private int partitionSize = 0x100000;
    private String checkpoint = "checkpoint_location";
    private int threadNum = 5;
    private VodUploadVideoConfigResponse vodUploadVideoConfigResponse;

    public PolyvUploadClient() {
        this.checkArgument();
    }

    public PolyvUploadClient(int partitionSize, String checkpoint, int threadNum) {
        this.partitionSize = partitionSize;
        this.checkpoint = checkpoint;
        this.threadNum = threadNum;
        this.checkArgument();
    }

    public String uploadVideo(CommonReqeust commonRequest, UploadCallBack callBack, boolean printProcessLog) {
        VodUploadVideoConfigRequest vodUploadVideoConfigRequest = null;
        if (commonRequest instanceof VodUploadVideoRequest) {
            VodUploadVideoRequest vodUploadVideoRequest = (VodUploadVideoRequest)commonRequest;
            this.validateBean(vodUploadVideoRequest);
            vodUploadVideoConfigRequest = new VodUploadVideoConfigRequest(vodUploadVideoRequest);
        } else if (commonRequest instanceof VodUploadVideoPartsRequest) {
            VodUploadVideoPartsRequest vodUploadVideoPartsRequest = (VodUploadVideoPartsRequest)commonRequest;
            this.validateBean(vodUploadVideoPartsRequest);
            vodUploadVideoConfigRequest = new VodUploadVideoConfigRequest(vodUploadVideoPartsRequest);
        } else {
            throw new PloyvSdkException(Constant.ERROR_CODE, "\u70b9\u64ad\u4e0a\u4f20\u89c6\u9891\u5bf9\u8c61\u5f02\u5e38");
        }
        return this.uploadVideoParts(vodUploadVideoConfigRequest, callBack, printProcessLog);
    }

    private String uploadVideoParts(VodUploadVideoConfigRequest vodUploadVideoConfigRequest, UploadCallBack callBack, boolean printProcessLog) {
        long startTime = System.currentTimeMillis();
        this.vodUploadVideoConfigResponse = new VodUploadVideoService().initUploadQueue(vodUploadVideoConfigRequest, 3);
        boolean upload = this.startUpload(vodUploadVideoConfigRequest, callBack, printProcessLog);
        if (upload) {
            log.info("upload success. cost {} ms", (Object)(System.currentTimeMillis() - startTime));
        } else {
            log.error("upload failed. cost {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return this.vodUploadVideoConfigResponse.getVid();
    }

    public boolean startUpload(final VodUploadVideoConfigRequest videoInfo, final UploadCallBack eventCallBack, final boolean printProcessLog) {
        String accessKeyId = this.vodUploadVideoConfigResponse.getAccessId();
        String accessKeySecret = this.vodUploadVideoConfigResponse.getAccessKey();
        String bucketName = this.vodUploadVideoConfigResponse.getBucketName();
        String securityToken = this.vodUploadVideoConfigResponse.getToken();
        String domain = this.vodUploadVideoConfigResponse.getDomain();
        int taskNum = this.threadNum;
        long validityTime = this.vodUploadVideoConfigResponse.getValidityTime();
        final String vId = this.vodUploadVideoConfigResponse.getVid();
        String objectName = this.vodUploadVideoConfigResponse.getDir() + vId + "." + this.getExtension(videoInfo.getFile().getPath());
        String fileLocation = videoInfo.getFile().getPath();
        String checkpointFile = this.checkpoint + "/" + vId + ".ucp";
        OSS ossClient = this.buildOssClient(domain, accessKeyId, accessKeySecret, securityToken, this.vodUploadVideoConfigResponse.getStartTime() + validityTime * 1000L);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentType("text/plain");
        UploadFileRequest uploadFileRequest = new UploadFileRequest(bucketName, objectName);
        uploadFileRequest.setUploadFile(fileLocation);
        uploadFileRequest.setTaskNum(taskNum);
        uploadFileRequest.setPartSize(this.partitionSize);
        uploadFileRequest.setEnableCheckpoint(true);
        uploadFileRequest.setCheckpointFile(checkpointFile);
        uploadFileRequest.setObjectMetadata(meta);
        Callback callback = JSON.parseObject(this.vodUploadVideoConfigResponse.getCallback(), Callback.class);
        uploadFileRequest.setCallback(callback);
        uploadFileRequest.setProgressListener(new ProgressListener(){
            private long bytesWritten = 0L;
            private long totalBytes = -1L;
            private boolean succeed = false;
            private long totalFileSize = videoInfo.getFileSize();

            @Override
            public void progressChanged(ProgressEvent progressEvent) {
                long bytes = progressEvent.getBytes();
                ProgressEventType eventType = progressEvent.getEventType();
                String videoPoolId = vId;
                switch (eventType) {
                    case TRANSFER_STARTED_EVENT: {
                        eventCallBack.start(videoPoolId);
                        if (!printProcessLog) break;
                        log.info("\u3010{}\u3011vid={}, Start to upload......", (Object)videoInfo.getTitle(), (Object)videoPoolId);
                        log.info("\u3010{}\u3011File size is {} bytes", (Object)videoPoolId, (Object)this.totalFileSize);
                        break;
                    }
                    case REQUEST_CONTENT_LENGTH_EVENT: {
                        this.totalBytes = bytes;
                        if (!printProcessLog) break;
                        log.info("\u3010{}\u3011{} bytes in total will be uploaded to Server", (Object)videoPoolId, (Object)this.totalBytes);
                        break;
                    }
                    case REQUEST_BYTE_TRANSFER_EVENT: {
                        this.bytesWritten += bytes;
                        eventCallBack.process(videoPoolId, this.totalFileSize - this.totalBytes + this.bytesWritten, this.totalFileSize);
                        if (!printProcessLog) break;
                        if (this.totalBytes != -1L) {
                            int percent = (int)((double)(this.totalFileSize - this.totalBytes + this.bytesWritten) * 100.0 / (double)this.totalFileSize);
                            log.info("\u3010{}\u3011{} bytes have been written at this time, upload progress: {}%({}/{})", videoPoolId, bytes, percent, this.totalFileSize - this.totalBytes + this.bytesWritten, this.totalFileSize);
                            break;
                        }
                        log.info("\u3010{}\u3011{} bytes have been written at this time, upload ratio: unknown({}/...)", videoPoolId, bytes, this.totalFileSize - this.totalBytes + this.bytesWritten);
                        break;
                    }
                    case TRANSFER_COMPLETED_EVENT: {
                        this.succeed = true;
                        eventCallBack.complete(videoPoolId);
                        if (!printProcessLog) break;
                        log.info("\u3010{}\u3011Succeed to upload, {} bytes have been transferred in total", (Object)videoPoolId, (Object)(this.totalFileSize - this.totalBytes + this.bytesWritten));
                        break;
                    }
                    case TRANSFER_FAILED_EVENT: {
                        eventCallBack.error(videoPoolId, UploadErrorMsg.ERROR_UPLOAD_PART);
                        if (!printProcessLog) break;
                        log.info("\u3010{}\u3011Failed to upload, {} bytes have been transferred", (Object)videoPoolId, (Object)(this.totalFileSize - this.totalBytes + this.bytesWritten));
                        break;
                    }
                }
            }
        });
        return this.triggerUpload(vId, ossClient, uploadFileRequest, 3, eventCallBack);
    }

    private boolean triggerUpload(String videoPoolId, OSS ossClient, UploadFileRequest uploadFileRequest, int retry, UploadCallBack eventCallBack) {
        try {
            ossClient.uploadFile(uploadFileRequest);
            ossClient.shutdown();
            eventCallBack.success(videoPoolId);
            return true;
        }
        catch (OSSException e) {
            if (("InvalidAccessKeyId".equals(e.getErrorCode()) || "SecurityTokenExpired".equals(e.getErrorCode())) && retry > 0) {
                log.info("token is expired. reupload the video. retry={}, requestId={}", (Object)retry, (Object)e.getRequestId());
                ossClient = this.reBuildOssClient();
                return this.triggerUpload(videoPoolId, ossClient, uploadFileRequest, --retry, eventCallBack);
            }
            log.error(e.getMessage(), e);
            eventCallBack.error(videoPoolId, UploadErrorMsg.ERROR_UPLOAD_TOKEN_EXPIRE);
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage(), throwable);
            eventCallBack.error(videoPoolId, UploadErrorMsg.ERROR_UPLOAD_EXCEPTION);
        }
        ossClient.shutdown();
        return false;
    }

    private <E extends CommonReqeust> void validateBean(E e) {
        List<ViolationMsg> violationMsgList = SDKValidateUtil.validateBean(e, new Class[0]);
        if (!violationMsgList.isEmpty()) {
            String errors = SDKValidateUtil.getViolationMsgStr(violationMsgList);
            errors = errors.substring(0, errors.length() - 3);
            errors = "\u8f93\u5165\u53c2\u6570 [" + e.getClass().getName() + "]\u5bf9\u8c61\u6821\u9a8c\u5931\u8d25 ,\u5931\u8d25\u5b57\u6bb5 [" + errors + "]";
            throw new PloyvSdkException(Constant.ERROR_CODE, errors);
        }
    }

    private OSS reBuildOssClient() {
        VodUploadVideoConfigResponse vodUploadVideoConfigResponse = null;
        vodUploadVideoConfigResponse = new VodUploadVideoService().getUploadToken(3);
        String accessKeyId = vodUploadVideoConfigResponse.getAccessId();
        String accessKeySecret = vodUploadVideoConfigResponse.getAccessKey();
        String securityToken = vodUploadVideoConfigResponse.getToken();
        String domain = vodUploadVideoConfigResponse.getDomain();
        long validityTime = vodUploadVideoConfigResponse.getValidityTime();
        return this.buildOssClient(domain, accessKeyId, accessKeySecret, securityToken, System.currentTimeMillis() + validityTime);
    }

    private OSS buildOssClient(String endpoint, String accessKeyId, String accessKeySecret, String securityToken, long expireTime) {
        ClientBuilderConfiguration ossConfig = new ClientBuilderConfiguration();
        ossConfig.setSupportCname(true);
        return new OSSClient(endpoint, new PolyvCredentialProvider(accessKeyId, accessKeySecret, securityToken, expireTime), ossConfig);
    }

    private String getExtension(String filename) {
        if (filename == null) {
            return "";
        }
        int extensionPos = filename.lastIndexOf(46);
        if (extensionPos < 0) {
            return "";
        }
        return filename.substring(extensionPos + 1);
    }

    private void checkArgument() {
        if (StringUtils.isBlank(this.checkpoint)) {
            throw new PloyvSdkException(Constant.ERROR_CODE, "PolyvUploadClient\u4e2dcheckpoint\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        File checkpointFile = new File(this.checkpoint);
        if (!checkpointFile.exists() && !checkpointFile.mkdirs()) {
            throw new PloyvSdkException(Constant.ERROR_CODE, "PolyvUploadClient\u4e2dcheckpoint\u8def\u5f84\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u3002");
        }
        if (this.threadNum <= 0) {
            this.threadNum = 5;
        }
        if (this.partitionSize < 102400 || this.partitionSize > 0x40000000) {
            this.partitionSize = 102400;
        }
    }
}

