package net.polyv.vod.v1.entity.play.payersettings;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vod.v1.entity.VodCommonRequest;

/**
 * 修改播放域名限制设置请求实体
 * @author: fangyan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改播放域名限制设置请求实体")
public class VodUpdatePlayDomainRequest extends VodCommonRequest {
    /**
     * 限制类型，0：无域名限制，1：黑名单，2：白名单，3：白名单和黑名单复合限制
     */
    @ApiModelProperty(name = "settingType", value = "限制类型，0：无域名限制，1：黑名单，2：白名单，3：白名单和黑名单复合限制", required = true)
    @NotNull(message = "属性settingType不能为空")
    private Integer settingType;
    
    /**
     * 域名配置，多个域名以英文逗号分隔，此参数仅在settingType值为1和2时且不为null时有效
     */
    @ApiModelProperty(name = "host", value = "禁止播放的域名（黑名单），多个域名以英文逗号分隔，在settingType = 1时有效", required = false)
    private String host;
}
