/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.deserializer.AbstractDateDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class SqlDateDeserializer
extends AbstractDateDeserializer
implements ObjectDeserializer {
    public static final SqlDateDeserializer instance = new SqlDateDeserializer();
    public static final SqlDateDeserializer instance_timestamp = new SqlDateDeserializer(true);
    private boolean timestamp = false;

    public SqlDateDeserializer() {
    }

    public SqlDateDeserializer(boolean timestmap) {
        this.timestamp = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T cast(DefaultJSONParser parser, Type clazz, Object fieldName, Object val2) {
        if (this.timestamp) {
            return this.castTimestamp(parser, clazz, fieldName, val2);
        }
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Date) {
            val2 = new java.sql.Date(((Date)val2).getTime());
        } else if (val2 instanceof BigDecimal) {
            val2 = new java.sql.Date(TypeUtils.longValue((BigDecimal)val2));
        } else if (val2 instanceof Number) {
            val2 = new java.sql.Date(((Number)val2).longValue());
        } else {
            if (val2 instanceof String) {
                long longVal;
                block17: {
                    String strVal = (String)val2;
                    if (strVal.length() == 0) {
                        return null;
                    }
                    JSONScanner dateLexer = new JSONScanner(strVal);
                    try {
                        java.sql.Date date;
                        if (dateLexer.scanISO8601DateIfMatch()) {
                            longVal = dateLexer.getCalendar().getTimeInMillis();
                            break block17;
                        }
                        DateFormat dateFormat = parser.getDateFormat();
                        try {
                            java.sql.Date sqlDate;
                            Date date2 = dateFormat.parse(strVal);
                            date = sqlDate = new java.sql.Date(date2.getTime());
                        }
                        catch (ParseException parseException) {
                            longVal = Long.parseLong(strVal);
                            break block17;
                        }
                        return (T)date;
                    }
                    finally {
                        dateLexer.close();
                    }
                }
                return (T)new java.sql.Date(longVal);
            }
            throw new JSONException("parse error : " + val2);
        }
        return (T)val2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T castTimestamp(DefaultJSONParser parser, Type clazz, Object fieldName, Object val2) {
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Date) {
            return (T)new Timestamp(((Date)val2).getTime());
        }
        if (val2 instanceof BigDecimal) {
            return (T)new Timestamp(TypeUtils.longValue((BigDecimal)val2));
        }
        if (val2 instanceof Number) {
            return (T)new Timestamp(((Number)val2).longValue());
        }
        if (val2 instanceof String) {
            long longVal;
            block15: {
                String strVal = (String)val2;
                if (strVal.length() == 0) {
                    return null;
                }
                JSONScanner dateLexer = new JSONScanner(strVal);
                try {
                    Timestamp timestamp;
                    String dateFomartPattern;
                    if (strVal.length() > 19 && strVal.charAt(4) == '-' && strVal.charAt(7) == '-' && strVal.charAt(10) == ' ' && strVal.charAt(13) == ':' && strVal.charAt(16) == ':' && strVal.charAt(19) == '.' && (dateFomartPattern = parser.getDateFomartPattern()).length() != strVal.length() && dateFomartPattern == JSON.DEFFAULT_DATE_FORMAT) {
                        Timestamp timestamp2 = Timestamp.valueOf(strVal);
                        return (T)timestamp2;
                    }
                    if (dateLexer.scanISO8601DateIfMatch(false)) {
                        longVal = dateLexer.getCalendar().getTimeInMillis();
                        break block15;
                    }
                    DateFormat dateFormat = parser.getDateFormat();
                    try {
                        Timestamp sqlDate;
                        Date date = dateFormat.parse(strVal);
                        timestamp = sqlDate = new Timestamp(date.getTime());
                    }
                    catch (ParseException parseException) {
                        longVal = Long.parseLong(strVal);
                        break block15;
                    }
                    return (T)timestamp;
                }
                finally {
                    dateLexer.close();
                }
            }
            return (T)new Timestamp(longVal);
        }
        throw new JSONException("parse error");
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

