/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverterImpl;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBPermission;
import javax.xml.bind.Messages;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public final class DatatypeConverter {
    private static DatatypeConverterInterface theConverter = new DatatypeConverterImpl();
    private static final JAXBPermission SET_DATATYPE_CONVERTER_PERMISSION = new JAXBPermission("setDatatypeConverter");

    private DatatypeConverter() {
    }

    public static void setDatatypeConverter(DatatypeConverterInterface converter) {
        if (converter == null) {
            throw new IllegalArgumentException(Messages.format("DatatypeConverter.ConverterMustNotBeNull"));
        }
        if (theConverter == null) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(SET_DATATYPE_CONVERTER_PERMISSION);
            }
            theConverter = converter;
        }
    }

    public static String parseString(String lexicalXSDString) {
        return theConverter.parseString(lexicalXSDString);
    }

    public static BigInteger parseInteger(String lexicalXSDInteger) {
        return theConverter.parseInteger(lexicalXSDInteger);
    }

    public static int parseInt(String lexicalXSDInt) {
        return theConverter.parseInt(lexicalXSDInt);
    }

    public static long parseLong(String lexicalXSDLong) {
        return theConverter.parseLong(lexicalXSDLong);
    }

    public static short parseShort(String lexicalXSDShort) {
        return theConverter.parseShort(lexicalXSDShort);
    }

    public static BigDecimal parseDecimal(String lexicalXSDDecimal) {
        return theConverter.parseDecimal(lexicalXSDDecimal);
    }

    public static float parseFloat(String lexicalXSDFloat) {
        return theConverter.parseFloat(lexicalXSDFloat);
    }

    public static double parseDouble(String lexicalXSDDouble) {
        return theConverter.parseDouble(lexicalXSDDouble);
    }

    public static boolean parseBoolean(String lexicalXSDBoolean) {
        return theConverter.parseBoolean(lexicalXSDBoolean);
    }

    public static byte parseByte(String lexicalXSDByte) {
        return theConverter.parseByte(lexicalXSDByte);
    }

    public static QName parseQName(String lexicalXSDQName, NamespaceContext nsc) {
        return theConverter.parseQName(lexicalXSDQName, nsc);
    }

    public static Calendar parseDateTime(String lexicalXSDDateTime) {
        return theConverter.parseDateTime(lexicalXSDDateTime);
    }

    public static byte[] parseBase64Binary(String lexicalXSDBase64Binary) {
        return theConverter.parseBase64Binary(lexicalXSDBase64Binary);
    }

    public static byte[] parseHexBinary(String lexicalXSDHexBinary) {
        return theConverter.parseHexBinary(lexicalXSDHexBinary);
    }

    public static long parseUnsignedInt(String lexicalXSDUnsignedInt) {
        return theConverter.parseUnsignedInt(lexicalXSDUnsignedInt);
    }

    public static int parseUnsignedShort(String lexicalXSDUnsignedShort) {
        return theConverter.parseUnsignedShort(lexicalXSDUnsignedShort);
    }

    public static Calendar parseTime(String lexicalXSDTime) {
        return theConverter.parseTime(lexicalXSDTime);
    }

    public static Calendar parseDate(String lexicalXSDDate) {
        return theConverter.parseDate(lexicalXSDDate);
    }

    public static String parseAnySimpleType(String lexicalXSDAnySimpleType) {
        return theConverter.parseAnySimpleType(lexicalXSDAnySimpleType);
    }

    public static String printString(String val2) {
        return theConverter.printString(val2);
    }

    public static String printInteger(BigInteger val2) {
        return theConverter.printInteger(val2);
    }

    public static String printInt(int val2) {
        return theConverter.printInt(val2);
    }

    public static String printLong(long val2) {
        return theConverter.printLong(val2);
    }

    public static String printShort(short val2) {
        return theConverter.printShort(val2);
    }

    public static String printDecimal(BigDecimal val2) {
        return theConverter.printDecimal(val2);
    }

    public static String printFloat(float val2) {
        return theConverter.printFloat(val2);
    }

    public static String printDouble(double val2) {
        return theConverter.printDouble(val2);
    }

    public static String printBoolean(boolean val2) {
        return theConverter.printBoolean(val2);
    }

    public static String printByte(byte val2) {
        return theConverter.printByte(val2);
    }

    public static String printQName(QName val2, NamespaceContext nsc) {
        return theConverter.printQName(val2, nsc);
    }

    public static String printDateTime(Calendar val2) {
        return theConverter.printDateTime(val2);
    }

    public static String printBase64Binary(byte[] val2) {
        return theConverter.printBase64Binary(val2);
    }

    public static String printHexBinary(byte[] val2) {
        return theConverter.printHexBinary(val2);
    }

    public static String printUnsignedInt(long val2) {
        return theConverter.printUnsignedInt(val2);
    }

    public static String printUnsignedShort(int val2) {
        return theConverter.printUnsignedShort(val2);
    }

    public static String printTime(Calendar val2) {
        return theConverter.printTime(val2);
    }

    public static String printDate(Calendar val2) {
        return theConverter.printDate(val2);
    }

    public static String printAnySimpleType(String val2) {
        return theConverter.printAnySimpleType(val2);
    }
}

