/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.service.datastatistics.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.List;
import net.polyv.vod.v1.config.VodGlobalConfig;
import net.polyv.vod.v1.constant.VodURL;
import net.polyv.vod.v1.entity.datastatistics.VodGetVideoPlayLogRequest;
import net.polyv.vod.v1.entity.datastatistics.VodGetVideoPlayLogResponse;
import net.polyv.vod.v1.entity.datastatistics.VodGetVideoViewingCompletionRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryAudienceAnalysisResultsRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryAudienceAnalysisResultsResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryPlayDomainNameStatisticsRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryPlayDomainNameStatisticsResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoAnalysisDataRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoAnalysisDataResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoDeviceStatisticsRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoDeviceStatisticsResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoGeographicStatisticsRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoGeographicStatisticsResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoPlayTimeStatisticsRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoPlayTimeStatisticsResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoPlaybackFlowSizeStatisticsRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoPlaybackFlowSizeStatisticsResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoPlaybackHourlyStatisticsRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoPlaybackHourlyStatisticsResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoPlaybackRankingRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoPlaybackRankingResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoPlaybackStatisticsRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoPlaybackStatisticsResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoViewershipRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoViewershipResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoViewingHotspotStatisticsRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoViewingHotspotStatisticsResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoViewingRatioStatisticsRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryVideoViewingRatioStatisticsResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryViewLogByDayRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryViewLogByDayResponse;
import net.polyv.vod.v1.entity.datastatistics.VodQueryViewingBehaviorListRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryViewingBehaviorListResponse;
import net.polyv.vod.v1.service.VodBaseService;
import net.polyv.vod.v1.service.datastatistics.IVodDataStatisticsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VodDataStatisticsServiceImpl
extends VodBaseService
implements IVodDataStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(VodDataStatisticsServiceImpl.class);

    @Override
    public List<VodQueryViewLogByDayResponse> queryViewLogByDay(VodQueryViewLogByDayRequest vodQueryViewLogByDayRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/data/%s/viewlog");
        return super.getReturnList(url, vodQueryViewLogByDayRequest, VodQueryViewLogByDayResponse.class);
    }

    @Override
    public VodGetVideoPlayLogResponse getVideoPlayLog(VodGetVideoPlayLogRequest vodGetVideoPlayLogRequest) throws IOException, NoSuchAlgorithmException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
        String url = VodURL.getRealUrl("api.polyv.net/v2/viewlog/%s/monthly/%s", VodGlobalConfig.getUserId(), simpleDateFormat.format(vodGetVideoPlayLogRequest.getMonth()));
        VodGetVideoPlayLogResponse vodGetVideoPlayLogResponse = super.getReturnOne(url, vodGetVideoPlayLogRequest, VodGetVideoPlayLogResponse.class);
        vodGetVideoPlayLogResponse.setPageSize(vodGetVideoPlayLogRequest.getPageSize());
        return vodGetVideoPlayLogResponse;
    }

    @Override
    public List<VodQueryVideoPlaybackStatisticsResponse> queryVideoPlaybackStatistics(VodQueryVideoPlaybackStatisticsRequest vodQueryVideoPlaybackStatisticsRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/videoview/%s");
        return super.getReturnList(url, vodQueryVideoPlaybackStatisticsRequest, VodQueryVideoPlaybackStatisticsResponse.class);
    }

    @Override
    public VodQueryVideoPlaybackRankingResponse queryVideoPlaybackRanking(VodQueryVideoPlaybackRankingRequest vodQueryVideoPlaybackRankingRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/videoview/%s/ranklist");
        return super.getReturnOne(url, vodQueryVideoPlaybackRankingRequest, VodQueryVideoPlaybackRankingResponse.class);
    }

    @Override
    public List<VodQueryPlayDomainNameStatisticsResponse> queryPlayDomainNameStatistics(VodQueryPlayDomainNameStatisticsRequest vodQueryPlayDomainNameStatisticsRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/domain/%s");
        return super.getReturnList(url, vodQueryPlayDomainNameStatisticsRequest, VodQueryPlayDomainNameStatisticsResponse.class);
    }

    @Override
    public VodQueryVideoDeviceStatisticsResponse queryVideoDeviceStatistics(VodQueryVideoDeviceStatisticsRequest vodQueryVideoDeviceStatisticsRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/device/%s");
        return super.getReturnOne(url, vodQueryVideoDeviceStatisticsRequest, VodQueryVideoDeviceStatisticsResponse.class);
    }

    @Override
    public List<VodQueryVideoPlaybackHourlyStatisticsResponse> queryVideoPlaybackHourlyStatistics(VodQueryVideoPlaybackHourlyStatisticsRequest vodQueryVideoPlaybackHourlyStatisticsRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/hourly/%s");
        return super.getReturnList(url, vodQueryVideoPlaybackHourlyStatisticsRequest, VodQueryVideoPlaybackHourlyStatisticsResponse.class);
    }

    @Override
    public List<VodQueryVideoGeographicStatisticsResponse> queryVideoGeographicStatistics(VodQueryVideoGeographicStatisticsRequest vodQueryVideoGeographicStatisticsRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/geo/%s");
        return super.getReturnList(url, vodQueryVideoGeographicStatisticsRequest, VodQueryVideoGeographicStatisticsResponse.class);
    }

    @Override
    public List<VodQueryVideoViewershipResponse> queryVideoViewership(VodQueryVideoViewershipRequest vodQueryVideoViewershipRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/data/visitor/%s");
        return super.getReturnList(url, vodQueryVideoViewershipRequest, VodQueryVideoViewershipResponse.class);
    }

    @Override
    public List<VodQueryVideoPlaybackFlowSizeStatisticsResponse> queryVideoPlaybackFlowSizeStatistics(VodQueryVideoPlaybackFlowSizeStatisticsRequest vodQueryVideoPlaybackFlowSizeStatisticsRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/traffic/%s/video/%s", VodGlobalConfig.getUserId(), vodQueryVideoPlaybackFlowSizeStatisticsRequest.getVideoId());
        return super.getReturnList(url, vodQueryVideoPlaybackFlowSizeStatisticsRequest, VodQueryVideoPlaybackFlowSizeStatisticsResponse.class);
    }

    @Override
    public List<VodQueryVideoPlayTimeStatisticsResponse> queryVideoPlayTimeStatistics(VodQueryVideoPlayTimeStatisticsRequest vodQueryVideoPlayTimeStatisticsRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/play-duration/%s", VodGlobalConfig.getUserId());
        return super.getReturnList(url, vodQueryVideoPlayTimeStatisticsRequest, VodQueryVideoPlayTimeStatisticsResponse.class);
    }

    @Override
    public List<VodQueryVideoViewingHotspotStatisticsResponse> queryVideoViewingHotspotStatistics(VodQueryVideoViewingHotspotStatisticsRequest vodQueryVideoViewingHotspotStatisticsRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/videohot/%s", VodGlobalConfig.getUserId());
        return super.getReturnList(url, vodQueryVideoViewingHotspotStatisticsRequest, VodQueryVideoViewingHotspotStatisticsResponse.class);
    }

    @Override
    public List<VodQueryVideoViewingRatioStatisticsResponse> queryVideoViewingRatioStatistics(VodQueryVideoViewingRatioStatisticsRequest vodQueryVideoViewingRatioStatisticsRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/play-ratio/%s", VodGlobalConfig.getUserId());
        return super.getReturnList(url, vodQueryVideoViewingRatioStatisticsRequest, VodQueryVideoViewingRatioStatisticsResponse.class);
    }

    @Override
    public Float getVideoViewingCompletion(VodGetVideoViewingCompletionRequest vodGetVideoViewingCompletionRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/video/engagement/%s/get", VodGlobalConfig.getUserId());
        return super.getReturnOne(url, vodGetVideoViewingCompletionRequest, Float.class);
    }

    @Override
    public VodQueryViewingBehaviorListResponse queryViewingBehaviorList(VodQueryViewingBehaviorListRequest vodQueryViewingBehaviorListRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/advance/play/%s", VodGlobalConfig.getUserId());
        VodQueryViewingBehaviorListResponse vodQueryViewingBehaviorListResponse = super.getReturnOne(url, vodQueryViewingBehaviorListRequest, VodQueryViewingBehaviorListResponse.class);
        vodQueryViewingBehaviorListResponse.setPageSize(vodQueryViewingBehaviorListRequest.getPageSize());
        return vodQueryViewingBehaviorListResponse;
    }

    @Override
    public VodQueryVideoAnalysisDataResponse queryVideoAnalysisData(VodQueryVideoAnalysisDataRequest vodQueryVideoAnalysisDataRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/advance/video/%s", VodGlobalConfig.getUserId());
        return super.getReturnOne(url, vodQueryVideoAnalysisDataRequest, VodQueryVideoAnalysisDataResponse.class);
    }

    @Override
    public VodQueryAudienceAnalysisResultsResponse queryAudienceAnalysisResults(VodQueryAudienceAnalysisResultsRequest vodQueryAudienceAnalysisResultsRequest) throws IOException, NoSuchAlgorithmException {
        String url = VodURL.getRealUrl("api.polyv.net/v2/advance/viewer/%s", VodGlobalConfig.getUserId());
        return super.getReturnOne(url, vodQueryAudienceAnalysisResultsRequest, VodQueryAudienceAnalysisResultsResponse.class);
    }
}

