/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.service;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.polyv.common.v1.base.HttpUtil;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.entity.CommonReqeust;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.MapUtil;
import net.polyv.common.v1.util.SDKValidateUtil;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.common.v1.validator.ViolationMsg;
import net.polyv.vod.v1.config.VodGlobalConfig;
import net.polyv.vod.v1.constant.VodURL;
import net.polyv.vod.v1.entity.VodCommonRequest;
import net.polyv.vod.v1.entity.VodCommonResponse;
import net.polyv.vod.v1.entity.VodSubCommonRequest;
import net.polyv.vod.v1.entity.VodSubPageCommonRequest;
import net.polyv.vod.v1.entity.datastatistics.VodQueryViewLogByDayRequest;
import net.polyv.vod.v1.entity.manage.category.VodDeleteCategoryRequest;
import net.polyv.vod.v1.entity.manage.category.VodGetCategoryRequest;
import net.polyv.vod.v1.entity.manage.category.VodMoveVideoRequest;
import net.polyv.vod.v1.entity.manage.category.VodUpdateCategoryNameRequest;
import net.polyv.vod.v1.entity.manage.edit.VodSaveVideoKeyFrameRequest;
import net.polyv.vod.v1.entity.play.payersettings.VodGetPlaySafeTokenRequest;
import net.polyv.vod.v1.util.VodSignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VodBaseService {
    private static final Logger log = LoggerFactory.getLogger(VodBaseService.class);
    public static final String ERROR_PREFIX = "\u4fdd\u5229\u5a01HTTP\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a";
    public static final String ERROR_INFO = " ,\u9519\u8bef\u539f\u56e0\uff1a ";
    public static final String ERROR_SUFFIX = " ,\u9519\u8bef\u539f\u56e0\uff1a \u670d\u52a1\u5668\u63a5\u53e3\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e";
    public static final String ERROR_PREFIX1 = "\u4fdd\u5229\u5a01\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a";

    protected <T, E extends VodCommonRequest> T getReturnOne(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseGet(url, e).parseData(tClass);
    }

    protected <T, E extends VodCommonRequest> List<T> getReturnList(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseGet(url, e).parseArray(tClass);
    }

    private <E extends VodCommonRequest> VodCommonResponse baseGet(String url, E e) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        url = this.appendProtocol(url);
        String response = HttpUtil.get(url, paramMap, this.getHttpHeadMap());
        return this.responseConversion(response, e.getRequestId());
    }

    protected <E extends VodCommonRequest> byte[] getReturnBinary(String url, E e) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        byte[] response = HttpUtil.getBinary(url = this.appendProtocol(url), paramMap, this.getHttpHeadMap(), null);
        if (response == null) {
            String message = ERROR_PREFIX + e.getRequestId() + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(Constant.ERROR_CODE, message);
            log.error(message, exception);
            throw exception;
        }
        return response;
    }

    protected <T, E extends VodCommonRequest> T postFormBodyReturnOne(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostFormBody(url, e).parseData(tClass);
    }

    protected <T, E extends VodCommonRequest> List<T> postFormBodyReturnList(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostFormBody(url, e).parseArray(tClass);
    }

    private <E extends VodCommonRequest> VodCommonResponse basePostFormBody(String url, E e) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        url = this.appendProtocol(url);
        String response = HttpUtil.postFormBody(url, paramMap, this.getHttpHeadMap());
        return this.responseConversion(response, e.getRequestId());
    }

    protected <T, E extends VodCommonRequest> List<T> postJsonBodyReturnList(String url, Map<String, String> signMap, E e, String json, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostJsonBody(url, signMap, e, json).parseArray(tClass);
    }

    protected <T, E extends VodCommonRequest> T postJsonBodyReturnOne(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        Map<String, String> signMap = VodSignUtil.getSignMap(e);
        return this.basePostJsonBody(url, signMap, e, "").parseData(tClass);
    }

    protected <T, E extends VodCommonRequest> T postJsonBodyReturnOne(String url, Map<String, String> signMap, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostJsonBody(url, signMap, e, "").parseData(tClass);
    }

    private <E extends VodCommonRequest> VodCommonResponse basePostJsonBody(String url, Map<String, String> signMap, E e, String json) throws IOException, NoSuchAlgorithmException {
        signMap = this.commonRequestLogic(signMap, e);
        this.validateBean(e);
        url = MapUtil.appendUrl(url, signMap);
        if (StringUtils.isBlank(json)) {
            json = JSON.toJSONString(e);
        }
        url = this.appendProtocol(url);
        String response = HttpUtil.postJsonBody(url, this.getHttpHeadMap(), json, null);
        return this.responseConversion(response, e.getRequestId());
    }

    protected <T, E extends VodCommonRequest> T uploadOneFile(String url, E e, Map<String, File> fileMap, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.uploadOneFile(url, e, fileMap).parseData(tClass);
    }

    private <E extends VodCommonRequest> VodCommonResponse uploadOneFile(String url, E e, Map<String, File> fileMap) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        url = this.appendProtocol(url);
        String response = HttpUtil.postFile(url, paramMap, fileMap, this.getHttpHeadMap(), null);
        return this.responseConversion(response, e.getRequestId());
    }

    protected <T, E extends VodCommonRequest> List<T> uploadMultipartFile(String url, E e, Map<String, List<File>> fileMap, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.uploadMultipartFile(url, e, fileMap).parseArray(tClass);
    }

    private <E extends VodCommonRequest> VodCommonResponse uploadMultipartFile(String url, E e, Map<String, List<File>> fileMap) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        url = this.appendProtocol(url);
        String response = HttpUtil.postMultipleFile(url, paramMap, fileMap, this.getHttpHeadMap(), null);
        return this.responseConversion(response, e.getRequestId());
    }

    private <E extends VodCommonRequest> Map<String, String> commonRequestLogic(Map<String, String> signMap, E e) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String sign;
        if (StringUtils.isBlank(e.getPtime())) {
            e.setPtime(String.valueOf(System.currentTimeMillis()));
        }
        if (StringUtils.isBlank(e.getRequestId())) {
            e.setRequestId(VodSignUtil.generateUUID());
        }
        if (e instanceof VodSubCommonRequest) {
            VodSubCommonRequest vodSubCommonRequest = (VodSubCommonRequest)e;
            String secretKey = vodSubCommonRequest.getSecretKey();
            vodSubCommonRequest.setTimestamp(String.valueOf(System.currentTimeMillis()));
            signMap = this.getNotNullMap(signMap, e);
            sign = VodSignUtil.setVodMd5Sign(signMap, secretKey);
        } else if (e instanceof VodSubPageCommonRequest) {
            VodSubPageCommonRequest subPageCommonRequest = (VodSubPageCommonRequest)e;
            String secretKey = subPageCommonRequest.getSecretKey();
            subPageCommonRequest.setTimestamp(String.valueOf(System.currentTimeMillis()));
            signMap = this.getNotNullMap(signMap, e);
            sign = VodSignUtil.setVodMd5Sign(signMap, secretKey);
        } else if (e instanceof VodQueryViewLogByDayRequest) {
            signMap = MapUtil.objectToMap(e);
            HashMap<String, String> innerMap = new HashMap<String, String>();
            innerMap.put("userid", VodGlobalConfig.getUserId());
            innerMap.put("day", signMap.get("day"));
            innerMap.put("ptime", signMap.get("ptime"));
            String secretKey = VodGlobalConfig.getSecretKey();
            sign = VodSignUtil.setVodSign(innerMap, secretKey);
            signMap.put("sign", sign);
        } else if (e instanceof VodDeleteCategoryRequest) {
            signMap = MapUtil.objectToMap(e);
            HashMap<String, String> innerMap = new HashMap<String, String>();
            innerMap.put("userid", VodGlobalConfig.getUserId());
            innerMap.put("cataid", signMap.get("cataid"));
            innerMap.put("ptime", signMap.get("ptime"));
            String secretKey = VodGlobalConfig.getSecretKey();
            sign = VodSignUtil.setVodSign(innerMap, secretKey);
            signMap.put("sign", sign);
        } else if (e instanceof VodGetCategoryRequest) {
            signMap = MapUtil.objectToMap(e);
            HashMap<String, String> innerMap = new HashMap<String, String>();
            innerMap.put("userid", VodGlobalConfig.getUserId());
            innerMap.put("ptime", signMap.get("ptime"));
            String secretKey = VodGlobalConfig.getSecretKey();
            sign = VodSignUtil.setVodSign(innerMap, secretKey);
            signMap.put("sign", sign);
        } else if (e instanceof VodMoveVideoRequest) {
            signMap = MapUtil.objectToMap(e);
            HashMap<String, String> innerMap = new HashMap<String, String>();
            innerMap.put("userid", VodGlobalConfig.getUserId());
            innerMap.put("vids", signMap.get("vids"));
            innerMap.put("cataid", signMap.get("cataid"));
            innerMap.put("ptime", signMap.get("ptime"));
            String secretKey = VodGlobalConfig.getSecretKey();
            sign = VodSignUtil.setVodSign(innerMap, secretKey);
            signMap.put("sign", sign);
        } else if (e instanceof VodUpdateCategoryNameRequest) {
            signMap = MapUtil.objectToMap(e);
            HashMap<String, String> innerMap = new HashMap<String, String>();
            innerMap.put("userid", VodGlobalConfig.getUserId());
            innerMap.put("cataname", signMap.get("cataname"));
            innerMap.put("cataid", signMap.get("cataid"));
            innerMap.put("ptime", signMap.get("ptime"));
            String secretKey = VodGlobalConfig.getSecretKey();
            sign = VodSignUtil.setVodSign(innerMap, secretKey);
            signMap.put("sign", sign);
        } else if (e instanceof VodSaveVideoKeyFrameRequest) {
            signMap = MapUtil.objectToMap(e);
            HashMap<String, String> innerMap = new HashMap<String, String>();
            innerMap.put("userid", VodGlobalConfig.getUserId());
            innerMap.put("vid", signMap.get("vid"));
            innerMap.put("ptime", signMap.get("ptime"));
            String secretKey = VodGlobalConfig.getSecretKey();
            sign = VodSignUtil.setVodSign(innerMap, secretKey);
            signMap.put("sign", sign);
        } else if (e instanceof VodGetPlaySafeTokenRequest) {
            VodGetPlaySafeTokenRequest vodGetPlaySafeTokenRequest = (VodGetPlaySafeTokenRequest)e;
            String secretKey = VodGlobalConfig.getSecretKey();
            signMap = this.getNotNullMap(signMap, e);
            sign = VodSignUtil.setVodMd5Sign(signMap, secretKey);
            signMap.put("sign", sign);
        } else {
            signMap = this.getNotNullMap(signMap, e);
            String secretKey = VodGlobalConfig.getSecretKey();
            sign = VodSignUtil.setVodSign(signMap, secretKey);
        }
        e.setSign(sign);
        this.validateBean(e);
        return signMap;
    }

    private <E extends VodCommonRequest> Map<String, String> getNotNullMap(Map<String, String> signMap, E e) {
        if (signMap == null) {
            signMap = MapUtil.objectToMap(e);
        }
        signMap = MapUtil.filterNullValue(signMap);
        return signMap;
    }

    protected <E extends CommonReqeust> void validateBean(E e) {
        List<ViolationMsg> violationMsgList = SDKValidateUtil.validateBean(e, new Class[0]);
        if (!violationMsgList.isEmpty()) {
            String errors = SDKValidateUtil.getViolationMsgStr(violationMsgList);
            errors = errors.substring(0, errors.length() - 3);
            errors = "\u8f93\u5165\u53c2\u6570 [" + e.getClass().getName() + "]\u5bf9\u8c61\u6821\u9a8c\u5931\u8d25 ,\u5931\u8d25\u5b57\u6bb5 [" + errors + "]";
            log.error(errors);
            throw new PloyvSdkException(Constant.ERROR_CODE, errors);
        }
    }

    private VodCommonResponse responseConversion(String response, String requestId) throws IOException, NoSuchAlgorithmException {
        VodCommonResponse vodCommonResponse;
        if (StringUtils.isNotBlank(response)) {
            vodCommonResponse = JSON.parseObject(response, VodCommonResponse.class);
            if (vodCommonResponse.getCode() != 200) {
                String msg = StringUtils.isBlank(vodCommonResponse.getMessage()) ? (StringUtils.isBlank(vodCommonResponse.getError().getDesc()) ? "\u670d\u52a1\u5668\u5904\u7406\u9519\u8bef" : vodCommonResponse.getError().getDesc()) : vodCommonResponse.getMessage();
                String message = ERROR_PREFIX1 + requestId + ERROR_INFO + msg;
                PloyvSdkException exception = new PloyvSdkException(vodCommonResponse.getCode(), message);
                log.error(message, exception);
                throw exception;
            }
        } else {
            String message = ERROR_PREFIX + requestId + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(Constant.ERROR_CODE, message);
            log.error(message, exception);
            throw exception;
        }
        return vodCommonResponse;
    }

    private Map<String, String> getHttpHeadMap() {
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("source", "JAVA_VOD_SDK");
        headMap.put("User-Agent", "JAVA_VOD_SDK");
        headMap.put("version", "1.1.12");
        headMap.put("java-sdk-user-id", VodGlobalConfig.getUserId());
        return headMap;
    }

    private String appendProtocol(String url) {
        url = this.removeProtocol(url);
        if (StringUtils.isNotEmpty(VodURL.getCustomUri()) && url.startsWith("api.polyv.net")) {
            url = url.replace("api.polyv.net", VodURL.getCustomUri());
        }
        url = VodURL.getIsHttps() ? "https://" + url : "http://" + url;
        return url;
    }

    private String removeProtocol(String url) {
        if ((url = url.trim()).startsWith("https://")) {
            url = url.substring(8);
        } else if (url.startsWith("http://")) {
            url = url.substring(7);
        }
        return url;
    }
}

