/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators;

import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraints.ModCheck;
import org.hibernate.validator.internal.util.ModUtil;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ModCheckValidator
implements ConstraintValidator<ModCheck, CharSequence> {
    private static final Log log = LoggerFactory.make();
    private static final String NUMBERS_ONLY_REGEXP = "[^0-9]";
    private static final int DEC_RADIX = 10;
    private int multiplier;
    private int startIndex;
    private int endIndex;
    private int checkDigitIndex;
    private ModCheck.ModType modType;
    private boolean ignoreNonDigitCharacters;

    @Override
    public void initialize(ModCheck constraintAnnotation) {
        this.modType = constraintAnnotation.modType();
        this.multiplier = constraintAnnotation.multiplier();
        this.startIndex = constraintAnnotation.startIndex();
        this.endIndex = constraintAnnotation.endIndex();
        this.checkDigitIndex = constraintAnnotation.checkDigitPosition();
        this.ignoreNonDigitCharacters = constraintAnnotation.ignoreNonDigitCharacters();
        if (this.startIndex < 0) {
            throw log.getStartIndexCannotBeNegativeException(this.startIndex);
        }
        if (this.endIndex < 0) {
            throw log.getEndIndexCannotBeNegativeException(this.endIndex);
        }
        if (this.startIndex > this.endIndex) {
            throw log.getInvalidRangeException(this.startIndex, this.endIndex);
        }
        if (this.checkDigitIndex > 0 && this.startIndex <= this.checkDigitIndex && this.endIndex > this.checkDigitIndex) {
            throw log.getInvalidCheckDigitException(this.startIndex, this.endIndex);
        }
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        List<Integer> digits;
        if (value == null) {
            return true;
        }
        String valueAsString = ((Object)value).toString();
        if (this.ignoreNonDigitCharacters) {
            valueAsString = valueAsString.replaceAll(NUMBERS_ONLY_REGEXP, "");
        }
        try {
            valueAsString = this.extractVerificationString(valueAsString);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        try {
            digits = this.extractDigits(valueAsString);
        }
        catch (NumberFormatException e) {
            return false;
        }
        boolean isValid = this.modType.equals((Object)ModCheck.ModType.MOD10) ? ModUtil.passesMod10Test(digits, this.multiplier) : ModUtil.passesMod11Test(digits, this.multiplier);
        return isValid;
    }

    private String extractVerificationString(String value) throws IndexOutOfBoundsException {
        if (this.endIndex == Integer.MAX_VALUE) {
            return value;
        }
        String verificationString = value.substring(this.startIndex, this.endIndex);
        if (this.checkDigitIndex > 0) {
            verificationString = verificationString + value.charAt(this.checkDigitIndex);
        }
        return verificationString;
    }

    private List<Integer> extractDigits(String value) throws NumberFormatException {
        char[] chars;
        ArrayList<Integer> digits = new ArrayList<Integer>(value.length());
        for (char c : chars = value.toCharArray()) {
            if (!Character.isDigit(c)) {
                throw log.getCharacterIsNotADigitException(c);
            }
            digits.add(Character.digit(c, 10));
        }
        return digits;
    }
}

