/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.DataOutputStream;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassFormatException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.LocalVariable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePair;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnotations;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisibleAnnotations;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisibleParameterAnnotations;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeParameterAnnotations;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisibleAnnotations;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisibleParameterAnnotations;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.annotation.AnnotationGen;
import org.aspectj.apache.bcel.util.ByteSequence;

public abstract class Utility {
    private static boolean wide = false;
    private static final int FREE_CHARS = 48;
    private static int[] CHAR_MAP = new int[48];
    private static int[] MAP_CHAR = new int[256];
    private static final char ESCAPE_CHAR = '$';

    static {
        int j = 0;
        boolean k = false;
        int i = 65;
        while (i <= 90) {
            Utility.CHAR_MAP[j] = i;
            Utility.MAP_CHAR[i] = j++;
            ++i;
        }
        i = 103;
        while (i <= 122) {
            Utility.CHAR_MAP[j] = i;
            Utility.MAP_CHAR[i] = j++;
            ++i;
        }
        Utility.CHAR_MAP[j] = 36;
        Utility.MAP_CHAR[36] = j++;
        Utility.CHAR_MAP[j] = 95;
        Utility.MAP_CHAR[95] = j;
    }

    public static final String accessToString(int access_flags) {
        return Utility.accessToString(access_flags, false);
    }

    public static final String accessToString(int access_flags, boolean for_class) {
        StringBuffer buf = new StringBuffer();
        int p = 0;
        int i = 0;
        while (p < 2048) {
            p = Utility.pow2(i);
            if ((access_flags & p) != 0 && (!for_class || p != 32 && p != 512)) {
                buf.append(Constants.ACCESS_NAMES[i]).append(" ");
            }
            ++i;
        }
        return buf.toString().trim();
    }

    public static final String classOrInterface(int access_flags) {
        return (access_flags & 0x200) != 0 ? "interface" : "class";
    }

    public static final String codeToString(byte[] code, ConstantPool constant_pool, int index, int length, boolean verbose) {
        StringBuffer buf = new StringBuffer(code.length * 20);
        ByteSequence stream = new ByteSequence(code);
        try {
            int i = 0;
            while (i < index) {
                Utility.codeToString(stream, constant_pool, verbose);
                ++i;
            }
            i = 0;
            while (stream.available() > 0) {
                if (length < 0 || i < length) {
                    String indices = Utility.fillup(String.valueOf(stream.getIndex()) + ":", 6, true, ' ');
                    buf.append(String.valueOf(indices) + Utility.codeToString(stream, constant_pool, verbose) + '\n');
                }
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println(buf.toString());
            e.printStackTrace();
            throw new ClassFormatException("Byte code error: " + e);
        }
        return buf.toString();
    }

    public static final String codeToString(byte[] code, ConstantPool constant_pool, int index, int length) {
        return Utility.codeToString(code, constant_pool, index, length, true);
    }

    public static final String codeToString(ByteSequence bytes, ConstantPool constant_pool) throws IOException {
        return Utility.codeToString(bytes, constant_pool, true);
    }

    public static final String compactClassName(String str) {
        return Utility.compactClassName(str, true);
    }

    public static final String compactClassName(String str, String prefix, boolean chopit) {
        int len = prefix.length();
        str = str.replace('/', '.');
        if (chopit && str.startsWith(prefix) && str.substring(len).indexOf(46) == -1) {
            str = str.substring(len);
        }
        return str;
    }

    public static final String compactClassName(String str, boolean chopit) {
        return Utility.compactClassName(str, "java.lang.", chopit);
    }

    public static final int setBit(int flag, int i) {
        return flag | Utility.pow2(i);
    }

    public static final int clearBit(int flag, int i) {
        int bit = Utility.pow2(i);
        return (flag & bit) == 0 ? flag : flag ^ bit;
    }

    public static final boolean isSet(int flag, int i) {
        return (flag & Utility.pow2(i)) != 0;
    }

    public static final String methodTypeToSignature(String returnType, String[] methodArgs) throws ClassFormatException {
        StringBuffer buf = new StringBuffer("(");
        if (methodArgs != null) {
            int i = 0;
            while (i < methodArgs.length) {
                String str = Utility.getSignature(methodArgs[i]);
                if (str.equals("V")) {
                    throw new ClassFormatException("Invalid type: " + methodArgs[i]);
                }
                buf.append(str);
                ++i;
            }
        }
        buf.append(")" + Utility.getSignature(returnType));
        return buf.toString();
    }

    public static final String[] methodSignatureArgumentTypes(String signature) throws ClassFormatException {
        return Utility.methodSignatureArgumentTypes(signature, true);
    }

    public static final String[] methodSignatureArgumentTypes(String signature, boolean chopit) throws ClassFormatException {
        ArrayList<String> vec = new ArrayList<String>();
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                ResultHolder rh = Utility.signatureToStringInternal(signature.substring(index), chopit);
                vec.add(rh.getResult());
                index += rh.getConsumedChars();
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        String[] types = new String[vec.size()];
        vec.toArray(types);
        return types;
    }

    public static final String methodSignatureReturnType(String signature) throws ClassFormatException {
        return Utility.methodSignatureReturnType(signature, true);
    }

    public static final String methodSignatureReturnType(String signature, boolean chopit) throws ClassFormatException {
        String type;
        try {
            int index = signature.lastIndexOf(41) + 1;
            type = Utility.signatureToString(signature.substring(index), chopit);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        return type;
    }

    public static final String methodSignatureToString(String signature, String name, String access) {
        return Utility.methodSignatureToString(signature, name, access, true);
    }

    public static final String methodSignatureToString(String signature, String name, String access, boolean chopit) {
        return Utility.methodSignatureToString(signature, name, access, chopit, null);
    }

    public static final String methodSignatureToString(String signature, String name, String access, boolean chopit, LocalVariableTable vars) throws ClassFormatException {
        String type;
        StringBuffer buf = new StringBuffer("(");
        int var_index = access.indexOf("static") >= 0 ? 0 : 1;
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                ResultHolder rh = Utility.signatureToStringInternal(signature.substring(index), chopit);
                String param_type = rh.getResult();
                buf.append(param_type);
                if (vars != null) {
                    LocalVariable l = vars.getLocalVariable(var_index);
                    if (l != null) {
                        buf.append(" " + l.getName());
                    }
                } else {
                    buf.append(" arg" + var_index);
                }
                var_index = "double".equals(param_type) || "long".equals(param_type) ? (var_index += 2) : ++var_index;
                buf.append(", ");
                index += rh.getConsumedChars();
            }
            type = Utility.signatureToString(signature.substring(++index), chopit);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        if (buf.length() > 1) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        return String.valueOf(access) + (access.length() > 0 ? " " : "") + type + " " + name + buf.toString();
    }

    public static final String replace(String str, String old, String new_) {
        StringBuffer buf = new StringBuffer();
        try {
            int index = str.indexOf(old);
            if (index != -1) {
                int old_index = 0;
                while ((index = str.indexOf(old, old_index)) != -1) {
                    buf.append(str.substring(old_index, index));
                    buf.append(new_);
                    old_index = index + old.length();
                }
                buf.append(str.substring(old_index));
                str = buf.toString();
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.println(e);
        }
        return str;
    }

    public static final String signatureToString(String signature) {
        return Utility.signatureToString(signature, true);
    }

    public static final String signatureToString(String signature, boolean chopit) {
        ResultHolder rh = Utility.signatureToStringInternal(signature, chopit);
        return rh.getResult();
    }

    public static final ResultHolder signatureToStringInternal(String signature, boolean chopit) {
        int processedChars = 1;
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return ResultHolder.BYTE;
                }
                case 'C': {
                    return ResultHolder.CHAR;
                }
                case 'D': {
                    return ResultHolder.DOUBLE;
                }
                case 'F': {
                    return ResultHolder.FLOAT;
                }
                case 'I': {
                    return ResultHolder.INT;
                }
                case 'J': {
                    return ResultHolder.LONG;
                }
                case 'L': {
                    int index = signature.indexOf(59);
                    if (index != -1 && signature.length() > index + 1 && signature.charAt(index + 1) == '>') {
                        index += 2;
                    }
                    if (index < 0) {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    int genericStart = signature.indexOf(60);
                    int genericEnd = signature.indexOf(62);
                    if (genericStart != -1) {
                        ResultHolder rh = Utility.signatureToStringInternal(signature.substring(genericStart + 1, genericEnd), chopit);
                        ResultHolder retval = new ResultHolder(Utility.compactClassName(String.valueOf(signature.substring(1, genericStart)) + "<" + rh.getResult() + ">", chopit), genericEnd + 1);
                        return retval;
                    }
                    processedChars = index + 1;
                    ResultHolder retval = new ResultHolder(Utility.compactClassName(signature.substring(1, index), chopit), processedChars);
                    return retval;
                }
                case 'S': {
                    return ResultHolder.SHORT;
                }
                case 'Z': {
                    return ResultHolder.BOOLEAN;
                }
                case '[': {
                    StringBuffer brackets = new StringBuffer();
                    int n = 0;
                    while (signature.charAt(n) == '[') {
                        brackets.append("[]");
                        ++n;
                    }
                    int consumedChars = n;
                    ResultHolder restOfIt = Utility.signatureToStringInternal(signature.substring(n), chopit);
                    return new ResultHolder(String.valueOf(restOfIt.getResult()) + brackets.toString(), consumedChars += restOfIt.getConsumedChars());
                }
                case 'V': {
                    return ResultHolder.VOID;
                }
            }
            throw new ClassFormatException("Invalid signature: `" + signature + "'");
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid signature: " + e + ":" + signature);
        }
    }

    public static String getSignature(String type) {
        StringBuffer buf = new StringBuffer();
        char[] chars = type.toCharArray();
        boolean char_found = false;
        boolean delim = false;
        int index = -1;
        int i = 0;
        block4: while (i < chars.length) {
            switch (chars[i]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!char_found) break;
                    delim = true;
                    break;
                }
                case '[': {
                    if (!char_found) {
                        throw new RuntimeException("Illegal type: " + type);
                    }
                    index = i;
                    break block4;
                }
                default: {
                    char_found = true;
                    if (delim) break;
                    buf.append(chars[i]);
                }
            }
            ++i;
        }
        int brackets = 0;
        if (index > 0) {
            brackets = Utility.countBrackets(type.substring(index));
        }
        type = buf.toString();
        buf.setLength(0);
        int i2 = 0;
        while (i2 < brackets) {
            buf.append('[');
            ++i2;
        }
        boolean found = false;
        int i3 = 4;
        while (i3 <= 12 && !found) {
            if (Constants.TYPE_NAMES[i3].equals(type)) {
                found = true;
                buf.append(Constants.SHORT_TYPE_NAMES[i3]);
            }
            ++i3;
        }
        if (!found) {
            buf.append(String.valueOf('L') + type.replace('.', '/') + ';');
        }
        return buf.toString();
    }

    public static final byte typeOfMethodSignature(String signature) throws ClassFormatException {
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = signature.lastIndexOf(41) + 1;
            return Utility.typeOfSignature(signature.substring(index));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
    }

    public static short searchOpcode(String name) {
        name = name.toLowerCase();
        short i = 0;
        while (i < Constants.OPCODE_NAMES.length) {
            if (Constants.OPCODE_NAMES[i].equals(name)) {
                return i;
            }
            i = (short)(i + 1);
        }
        return -1;
    }

    private static final short byteToShort(byte b) {
        return b < 0 ? (short)(256 + b) : (short)b;
    }

    public static final String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            short b = Utility.byteToShort(bytes[i]);
            String hex = Integer.toString(b, 16);
            if (b < 16) {
                buf.append('0');
            }
            buf.append(hex);
            if (i < bytes.length - 1) {
                buf.append(' ');
            }
            ++i;
        }
        return buf.toString();
    }

    public static final String format(int i, int length, boolean left_justify, char fill) {
        return Utility.fillup(Integer.toString(i), length, left_justify, fill);
    }

    public static final String fillup(String str, int length, boolean left_justify, char fill) {
        int len = length - str.length();
        char[] buf = new char[len < 0 ? 0 : len];
        int j = 0;
        while (j < buf.length) {
            buf[j] = fill;
            ++j;
        }
        if (left_justify) {
            return String.valueOf(str) + new String(buf);
        }
        return String.valueOf(new String(buf)) + str;
    }

    static final boolean equals(byte[] a, byte[] b) {
        int size = a.length;
        if (size != b.length) {
            return false;
        }
        int i = 0;
        while (i < size) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final void printArray(PrintStream out, Object[] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static final void printArray(PrintWriter out, Object[] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static final String printArray(Object[] obj) {
        return Utility.printArray(obj, true);
    }

    public static final String printArray(Object[] obj, boolean braces) {
        return Utility.printArray(obj, braces, false);
    }

    public static final String printArray(Object[] obj, boolean braces, boolean quote) {
        if (obj == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (braces) {
            buf.append('{');
        }
        int i = 0;
        while (i < obj.length) {
            if (obj[i] != null) {
                buf.append(String.valueOf(quote ? "\"" : "") + obj[i].toString() + (quote ? "\"" : ""));
            } else {
                buf.append("null");
            }
            if (i < obj.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        if (braces) {
            buf.append('}');
        }
        return buf.toString();
    }

    public static boolean isJavaIdentifierPart(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_';
    }

    public static String encode(byte[] bytes, boolean compress) throws IOException {
        if (compress) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            gos.write(bytes, 0, bytes.length);
            gos.close();
            baos.close();
            bytes = baos.toByteArray();
        }
        CharArrayWriter caw = new CharArrayWriter();
        JavaWriter jw = new JavaWriter(caw);
        int i = 0;
        while (i < bytes.length) {
            int in = bytes[i] & 0xFF;
            jw.write(in);
            ++i;
        }
        return caw.toString();
    }

    public static byte[] decode(String s, boolean uncompress) throws IOException {
        int ch;
        char[] chars = s.toCharArray();
        CharArrayReader car = new CharArrayReader(chars);
        JavaReader jr = new JavaReader(car);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((ch = jr.read()) >= 0) {
            bos.write(ch);
        }
        bos.close();
        car.close();
        jr.close();
        byte[] bytes = bos.toByteArray();
        if (uncompress) {
            int b;
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(bytes));
            byte[] tmp = new byte[bytes.length * 3];
            int count = 0;
            while ((b = gis.read()) >= 0) {
                tmp[count++] = (byte)b;
            }
            bytes = new byte[count];
            System.arraycopy(tmp, 0, bytes, 0, count);
        }
        return bytes;
    }

    public static final String convertString(String label) {
        char[] ch = label.toCharArray();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < ch.length) {
            switch (ch[i]) {
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                case '\'': {
                    buf.append("\\'");
                    break;
                }
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static List getListOfAnnotationNames(Annotation a) {
        List l = a.getValues();
        ArrayList<String> names = new ArrayList<String>();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            ElementNameValuePair element = (ElementNameValuePair)i.next();
            names.add(element.getNameString());
        }
        return names;
    }

    public static Attribute[] getAnnotationAttributes(ConstantPoolGen cp, List vec) {
        if (vec.size() == 0) {
            return null;
        }
        try {
            int countVisible = 0;
            int countInvisible = 0;
            int i = 0;
            while (i < vec.size()) {
                AnnotationGen a = (AnnotationGen)vec.get(i);
                if (a.isRuntimeVisible()) {
                    ++countVisible;
                } else {
                    ++countInvisible;
                }
                ++i;
            }
            ByteArrayOutputStream rvaBytes = new ByteArrayOutputStream();
            ByteArrayOutputStream riaBytes = new ByteArrayOutputStream();
            DataOutputStream rvaDos = new DataOutputStream(rvaBytes);
            DataOutputStream riaDos = new DataOutputStream(riaBytes);
            rvaDos.writeShort(countVisible);
            riaDos.writeShort(countInvisible);
            int i2 = 0;
            while (i2 < vec.size()) {
                AnnotationGen a = (AnnotationGen)vec.get(i2);
                if (a.isRuntimeVisible()) {
                    a.dump(rvaDos);
                } else {
                    a.dump(riaDos);
                }
                ++i2;
            }
            rvaDos.close();
            riaDos.close();
            byte[] rvaData = rvaBytes.toByteArray();
            byte[] riaData = riaBytes.toByteArray();
            int rvaIndex = -1;
            int riaIndex = -1;
            if (rvaData.length > 2) {
                rvaIndex = cp.addUtf8("RuntimeVisibleAnnotations");
            }
            if (riaData.length > 2) {
                riaIndex = cp.addUtf8("RuntimeInvisibleAnnotations");
            }
            ArrayList<RuntimeAnnotations> newAttributes = new ArrayList<RuntimeAnnotations>();
            if (rvaData.length > 2) {
                newAttributes.add(new RuntimeVisibleAnnotations(rvaIndex, rvaData.length, rvaData, cp.getConstantPool()));
            }
            if (riaData.length > 2) {
                newAttributes.add(new RuntimeInvisibleAnnotations(riaIndex, riaData.length, riaData, cp.getConstantPool()));
            }
            return newAttributes.toArray(new Attribute[0]);
        }
        catch (IOException e) {
            System.err.println("IOException whilst processing annotations");
            e.printStackTrace();
            return null;
        }
    }

    public static Attribute[] getParameterAnnotationAttributes(ConstantPoolGen cp, List[] vec) {
        int[] visCount = new int[vec.length];
        int totalVisCount = 0;
        int[] invisCount = new int[vec.length];
        int totalInvisCount = 0;
        try {
            int i = 0;
            while (i < vec.length) {
                List l = vec[i];
                if (l != null) {
                    Iterator iter = l.iterator();
                    while (iter.hasNext()) {
                        AnnotationGen element = (AnnotationGen)iter.next();
                        if (element.isRuntimeVisible()) {
                            int n = i;
                            visCount[n] = visCount[n] + 1;
                            ++totalVisCount;
                            continue;
                        }
                        int n = i;
                        invisCount[n] = invisCount[n] + 1;
                        ++totalInvisCount;
                    }
                }
                ++i;
            }
            ByteArrayOutputStream rvaBytes = new ByteArrayOutputStream();
            DataOutputStream rvaDos = new DataOutputStream(rvaBytes);
            rvaDos.writeByte(vec.length);
            int i2 = 0;
            while (i2 < vec.length) {
                rvaDos.writeShort(visCount[i2]);
                if (visCount[i2] > 0) {
                    List l = vec[i2];
                    Iterator iter = l.iterator();
                    while (iter.hasNext()) {
                        AnnotationGen element = (AnnotationGen)iter.next();
                        if (!element.isRuntimeVisible()) continue;
                        element.dump(rvaDos);
                    }
                }
                ++i2;
            }
            rvaDos.close();
            ByteArrayOutputStream riaBytes = new ByteArrayOutputStream();
            DataOutputStream riaDos = new DataOutputStream(riaBytes);
            riaDos.writeByte(vec.length);
            int i3 = 0;
            while (i3 < vec.length) {
                riaDos.writeShort(invisCount[i3]);
                if (invisCount[i3] > 0) {
                    List l = vec[i3];
                    Iterator iter = l.iterator();
                    while (iter.hasNext()) {
                        AnnotationGen element = (AnnotationGen)iter.next();
                        if (element.isRuntimeVisible()) continue;
                        element.dump(riaDos);
                    }
                }
                ++i3;
            }
            riaDos.close();
            byte[] rvaData = rvaBytes.toByteArray();
            byte[] riaData = riaBytes.toByteArray();
            int rvaIndex = -1;
            int riaIndex = -1;
            if (totalVisCount > 0) {
                rvaIndex = cp.addUtf8("RuntimeVisibleParameterAnnotations");
            }
            if (totalInvisCount > 0) {
                riaIndex = cp.addUtf8("RuntimeInvisibleParameterAnnotations");
            }
            ArrayList<RuntimeParameterAnnotations> newAttributes = new ArrayList<RuntimeParameterAnnotations>();
            if (totalVisCount > 0) {
                newAttributes.add(new RuntimeVisibleParameterAnnotations(rvaIndex, rvaData.length, rvaData, cp.getConstantPool()));
            }
            if (totalInvisCount > 0) {
                newAttributes.add(new RuntimeInvisibleParameterAnnotations(riaIndex, riaData.length, riaData, cp.getConstantPool()));
            }
            return newAttributes.toArray(new Attribute[0]);
        }
        catch (IOException e) {
            System.err.println("IOException whilst processing parameter annotations");
            e.printStackTrace();
            return null;
        }
    }

    private static final boolean is_digit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static final boolean is_space(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public static final byte typeOfSignature(String signature) throws ClassFormatException {
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return 8;
                }
                case 'C': {
                    return 5;
                }
                case 'D': {
                    return 7;
                }
                case 'F': {
                    return 6;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
                case 'L': {
                    return 14;
                }
                case '[': {
                    return 13;
                }
                case 'V': {
                    return 12;
                }
                case 'Z': {
                    return 4;
                }
                case 'S': {
                    return 9;
                }
            }
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
    }

    public static final String readClassTypeSignatureFrom(String signature) {
        StringBuffer sb = new StringBuffer();
        Utility.readClassTypeSignatureFrom(signature, 0, sb, false);
        return sb.toString();
    }

    public static final int readClassTypeSignatureFrom(String signature, int posn, StringBuffer result, boolean chopit) {
        int idx = posn;
        try {
            switch (signature.charAt(idx)) {
                case 'B': {
                    result.append("byte");
                    return 1;
                }
                case 'C': {
                    result.append("char");
                    return 1;
                }
                case 'D': {
                    result.append("double");
                    return 1;
                }
                case 'F': {
                    result.append("float");
                    return 1;
                }
                case 'I': {
                    result.append("int");
                    return 1;
                }
                case 'J': {
                    result.append("long");
                    return 1;
                }
                case 'S': {
                    result.append("short");
                    return 1;
                }
                case 'Z': {
                    result.append("boolean");
                    return 1;
                }
                case 'V': {
                    result.append("void");
                    return 1;
                }
                case 'T': {
                    int nextSemiIdx = signature.indexOf(59, ++idx);
                    result.append(signature.substring(idx, nextSemiIdx));
                    return nextSemiIdx + 1 - posn;
                }
                case '+': {
                    result.append("? extends ");
                    return Utility.readClassTypeSignatureFrom(signature, idx + 1, result, chopit) + 1;
                }
                case '-': {
                    result.append("? super ");
                    return Utility.readClassTypeSignatureFrom(signature, idx + 1, result, chopit) + 1;
                }
                case '*': {
                    result.append("?");
                    return 1;
                }
                case 'L': {
                    boolean parameterized = false;
                    int idxSemicolon = signature.indexOf(59, idx);
                    int idxAngly = signature.indexOf(60, idx);
                    int endOfSig = idxSemicolon;
                    if (idxAngly != -1 && idxAngly < endOfSig) {
                        endOfSig = idxAngly;
                        parameterized = true;
                    }
                    String p = signature.substring(idx + 1, endOfSig);
                    String t = Utility.compactClassName(p, chopit);
                    result.append(t);
                    idx = endOfSig;
                    if (parameterized) {
                        ++idx;
                        result.append("<");
                        while (signature.charAt(idx) != '>') {
                            if (signature.charAt(idx += Utility.readClassTypeSignatureFrom(signature, idx, result, chopit)) == '>') continue;
                            result.append(",");
                        }
                        result.append(">");
                        ++idx;
                    }
                    if (signature.charAt(idx) != ';') {
                        throw new RuntimeException("Did not find ';' at end of signature, found " + signature.charAt(idx));
                    }
                    return ++idx - posn;
                }
                case '[': {
                    int dim = 0;
                    while (signature.charAt(idx) == '[') {
                        ++dim;
                        ++idx;
                    }
                    idx += Utility.readClassTypeSignatureFrom(signature, idx, result, chopit);
                    while (dim > 0) {
                        result.append("[]");
                        --dim;
                    }
                    return idx - posn;
                }
            }
            throw new ClassFormatException("Invalid signature: `" + signature + "'");
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid signature: " + e + ":" + signature);
        }
    }

    private static int countBrackets(String brackets) {
        char[] chars = brackets.toCharArray();
        int count = 0;
        boolean open = false;
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '[': {
                    if (open) {
                        throw new RuntimeException("Illegally nested brackets:" + brackets);
                    }
                    open = true;
                    break;
                }
                case ']': {
                    if (!open) {
                        throw new RuntimeException("Illegally nested brackets:" + brackets);
                    }
                    open = false;
                    ++count;
                }
            }
            ++i;
        }
        if (open) {
            throw new RuntimeException("Illegally nested brackets:" + brackets);
        }
        return count;
    }

    public static final String codeToString(ByteSequence bytes, ConstantPool constant_pool, boolean verbose) throws IOException {
        int i;
        short opcode = (short)bytes.readUnsignedByte();
        int default_offset = 0;
        int no_pad_bytes = 0;
        StringBuffer buf = new StringBuffer(Constants.OPCODE_NAMES[opcode]);
        if (opcode == 170 || opcode == 171) {
            int remainder = bytes.getIndex() % 4;
            no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
            i = 0;
            while (i < no_pad_bytes) {
                byte b = bytes.readByte();
                if (b != 0) {
                    System.err.println("Warning: Padding byte != 0 in " + Constants.OPCODE_NAMES[opcode] + ":" + b);
                }
                ++i;
            }
            default_offset = bytes.readInt();
        }
        switch (opcode) {
            case 170: {
                int low = bytes.readInt();
                int high = bytes.readInt();
                int offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                buf.append("\tdefault = " + (default_offset += offset) + ", low = " + low + ", high = " + high + "(");
                int[] jump_table = new int[high - low + 1];
                int i2 = 0;
                while (i2 < jump_table.length) {
                    jump_table[i2] = offset + bytes.readInt();
                    buf.append(jump_table[i2]);
                    if (i2 < jump_table.length - 1) {
                        buf.append(", ");
                    }
                    ++i2;
                }
                buf.append(")");
                break;
            }
            case 171: {
                int npairs = bytes.readInt();
                int offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                int[] match = new int[npairs];
                int[] jump_table = new int[npairs];
                buf.append("\tdefault = " + (default_offset += offset) + ", npairs = " + npairs + " (");
                int i2 = 0;
                while (i2 < npairs) {
                    match[i2] = bytes.readInt();
                    jump_table[i2] = offset + bytes.readInt();
                    buf.append("(" + match[i2] + ", " + jump_table[i2] + ")");
                    if (i2 < npairs - 1) {
                        buf.append(", ");
                    }
                    ++i2;
                }
                buf.append(")");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                buf.append("\t\t#" + (bytes.getIndex() - 1 + bytes.readShort()));
                break;
            }
            case 200: 
            case 201: {
                buf.append("\t\t#" + (bytes.getIndex() - 1 + bytes.readInt()));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int vindex;
                if (wide) {
                    vindex = bytes.readUnsignedShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                }
                buf.append("\t\t%" + vindex);
                break;
            }
            case 196: {
                wide = true;
                buf.append("\t(wide)");
                break;
            }
            case 188: {
                buf.append("\t\t<" + Constants.TYPE_NAMES[bytes.readByte()] + ">");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t" + constant_pool.constantToString(index, (byte)9) + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 187: 
            case 192: {
                buf.append("\t");
            }
            case 193: {
                int index = bytes.readUnsignedShort();
                buf.append("\t<" + constant_pool.constantToString(index, (byte)7) + ">" + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                int index = bytes.readUnsignedShort();
                buf.append("\t" + constant_pool.constantToString(index, (byte)10) + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 185: {
                int index = bytes.readUnsignedShort();
                int nargs = bytes.readUnsignedByte();
                buf.append("\t" + constant_pool.constantToString(index, (byte)11) + (verbose ? " (" + index + ")\t" : "") + nargs + "\t" + bytes.readUnsignedByte());
                break;
            }
            case 19: 
            case 20: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t" + constant_pool.constantToString(index, constant_pool.getConstant(index).getTag()) + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 18: {
                int index = bytes.readUnsignedByte();
                buf.append("\t\t" + constant_pool.constantToString(index, constant_pool.getConstant(index).getTag()) + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 189: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t<" + Utility.compactClassName(constant_pool.getConstantString(index, (byte)7), false) + ">" + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 197: {
                int index = bytes.readUnsignedShort();
                int dimensions = bytes.readUnsignedByte();
                buf.append("\t<" + Utility.compactClassName(constant_pool.getConstantString(index, (byte)7), false) + ">\t" + dimensions + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 132: {
                short constant;
                int vindex;
                if (wide) {
                    vindex = bytes.readUnsignedShort();
                    constant = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                    constant = bytes.readByte();
                }
                buf.append("\t\t%" + vindex + "\t" + constant);
                break;
            }
            default: {
                if (Constants.NO_OF_OPERANDS[opcode] <= 0) break;
                i = 0;
                while (i < Constants.TYPE_OF_OPERANDS[opcode].length) {
                    buf.append("\t\t");
                    switch (Constants.TYPE_OF_OPERANDS[opcode][i]) {
                        case 8: {
                            buf.append(bytes.readByte());
                            break;
                        }
                        case 9: {
                            buf.append(bytes.readShort());
                            break;
                        }
                        case 10: {
                            buf.append(bytes.readInt());
                            break;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                    ++i;
                }
                break block0;
            }
        }
        return buf.toString();
    }

    private static final int pow2(int n) {
        return 1 << n;
    }

    private static class JavaReader
    extends FilterReader {
        public JavaReader(Reader in) {
            super(in);
        }

        public int read() throws IOException {
            int b = this.in.read();
            if (b != 36) {
                return b;
            }
            int i = this.in.read();
            if (i < 0) {
                return -1;
            }
            if (i >= 48 && i <= 57 || i >= 97 && i <= 102) {
                int j = this.in.read();
                if (j < 0) {
                    return -1;
                }
                char[] tmp = new char[]{(char)i, (char)j};
                int s = Integer.parseInt(new String(tmp), 16);
                return s;
            }
            return MAP_CHAR[i];
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int i = 0;
            while (i < len) {
                cbuf[off + i] = (char)this.read();
                ++i;
            }
            return len;
        }
    }

    private static class JavaWriter
    extends FilterWriter {
        public JavaWriter(Writer out) {
            super(out);
        }

        public void write(int b) throws IOException {
            if (Utility.isJavaIdentifierPart((char)b) && b != 36) {
                this.out.write(b);
            } else {
                this.out.write(36);
                if (b >= 0 && b < 48) {
                    this.out.write(CHAR_MAP[b]);
                } else {
                    char[] tmp = Integer.toHexString(b).toCharArray();
                    if (tmp.length == 1) {
                        this.out.write(48);
                        this.out.write(tmp[0]);
                    } else {
                        this.out.write(tmp[0]);
                        this.out.write(tmp[1]);
                    }
                }
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            int i = 0;
            while (i < len) {
                this.write(cbuf[off + i]);
                ++i;
            }
        }

        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), off, len);
        }
    }

    private static class ResultHolder {
        private String result;
        private int consumed;
        public static final ResultHolder BYTE = new ResultHolder("byte", 1);
        public static final ResultHolder CHAR = new ResultHolder("char", 1);
        public static final ResultHolder DOUBLE = new ResultHolder("double", 1);
        public static final ResultHolder FLOAT = new ResultHolder("float", 1);
        public static final ResultHolder INT = new ResultHolder("int", 1);
        public static final ResultHolder LONG = new ResultHolder("long", 1);
        public static final ResultHolder SHORT = new ResultHolder("short", 1);
        public static final ResultHolder BOOLEAN = new ResultHolder("boolean", 1);
        public static final ResultHolder VOID = new ResultHolder("void", 1);

        public ResultHolder(String s, int c) {
            this.result = s;
            this.consumed = c;
        }

        public String getResult() {
            return this.result;
        }

        public int getConsumedChars() {
            return this.consumed;
        }
    }
}

