/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.service;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import net.polyv.common.v1.base.HttpUtil;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.SDKValidateUtil;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.common.v1.validator.ViolationMsg;
import net.polyv.vod.v1.config.VodGlobalConfig;
import net.polyv.vod.v1.constant.VodConstant;
import net.polyv.vod.v1.entity.VodCommonRequest;
import net.polyv.vod.v1.entity.VodCommonResponse;
import net.polyv.vod.v1.util.MapUtil;
import net.polyv.vod.v1.util.VodSignUtil;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VodBaseService {
    private static final Logger log = LoggerFactory.getLogger(VodBaseService.class);

    protected <T, E extends VodCommonRequest> T baseGet(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseGet(url, null, e, tClass);
    }

    protected <T, E extends VodCommonRequest> T baseGet(String url, String pathVariable, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        VodCommonResponse VodCommonResponse2;
        T t = null;
        Map<String, String> paramMap = null;
        if (StringUtils.isBlank(e.getRequestId())) {
            e.setRequestId(VodSignUtil.generateUUID());
        }
        if ((url = url.trim()).startsWith("https://api.polyv.net/")) {
            if (e.getPtime() == null) {
                e.setPtime(System.currentTimeMillis());
            }
            e.setUserid(VodGlobalConfig.getUserId());
            paramMap = MapUtil.objectToMap(e);
            String sign = VodSignUtil.setVodSign(paramMap, VodGlobalConfig.getSecretKey());
            e.setSign(sign);
        } else {
            paramMap = MapUtil.objectToMap(e);
        }
        paramMap = MapUtil.filterNullValue(paramMap);
        this.validateBean(e);
        String queryStr = MapUtil.mapJoinNotEncode(paramMap);
        url = url + "?" + queryStr;
        String response = HttpUtil.get(url);
        if (StringUtils.isNotBlank(response)) {
            VodCommonResponse2 = JSON.parseObject(response, VodCommonResponse.class);
            if (VodCommonResponse2.getCode() != 200) {
                String message = "\u4fdd\u5229\u5a01HTTP\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a" + e.getRequestId() + " ,\u9519\u8bef\u539f\u56e0\uff1a " + VodCommonResponse2.getMessage();
                PloyvSdkException exception = new PloyvSdkException(VodCommonResponse2.getCode(), message);
                log.error(message, exception);
                throw exception;
            }
        } else {
            String message = "\u4fdd\u5229\u5a01HTTP\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a" + e.getRequestId() + " ,\u9519\u8bef\u539f\u56e0\uff1a \u670d\u52a1\u5668\u63a5\u53e3\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e";
            PloyvSdkException exception = new PloyvSdkException(VodConstant.ERROR_CODE, message);
            log.error(message, exception);
            throw exception;
        }
        t = VodCommonResponse2.parseData(tClass);
        return t;
    }

    private <E extends VodCommonRequest> void validateBean(E e) {
        List<ViolationMsg> violationMsgList = SDKValidateUtil.validateBean(e, new Class[0]);
        if (!violationMsgList.isEmpty()) {
            String errors = SDKValidateUtil.getViolationMsgStr(violationMsgList);
            errors = errors.substring(0, errors.length() - 3);
            errors = "\u8f93\u5165\u53c2\u6570 [" + e.getClass().getName() + "]\u5bf9\u8c61\u6821\u9a8c\u5931\u8d25 ,\u5931\u8d25\u5b57\u6bb5 [" + errors + "]";
            log.error(errors);
            throw new PloyvSdkException(VodConstant.ERROR_CODE, errors);
        }
    }

    protected <T, E extends VodCommonRequest> T basePost(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseGet(url, null, e, tClass);
    }

    protected <T, E extends VodCommonRequest> T basePost(String url, String pathVariable, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        VodCommonResponse VodCommonResponse2;
        T t = null;
        Map<String, String> paramMap = null;
        if (StringUtils.isBlank(e.getRequestId())) {
            e.setRequestId(VodSignUtil.generateUUID());
        }
        if ((url = url.trim()).startsWith("https://api.polyv.net/")) {
            e.setUserid(VodGlobalConfig.getUserId());
            if (e.getPtime() == null) {
                e.setPtime(System.currentTimeMillis());
            }
            paramMap = MapUtil.objectToMap(e);
            String sign = VodSignUtil.setVodSign(paramMap, VodGlobalConfig.getSecretKey());
            e.setSign(sign);
        } else {
            paramMap = MapUtil.objectToMap(e);
        }
        paramMap = MapUtil.filterNullValue(paramMap);
        this.validateBean(e);
        String response = HttpUtil.get(url);
        if (StringUtils.isNotBlank(response)) {
            VodCommonResponse2 = JSON.parseObject(response, VodCommonResponse.class);
            if (VodCommonResponse2.getCode() != 200) {
                String message = "\u4fdd\u5229\u5a01\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a" + e.getRequestId() + " ,\u9519\u8bef\u539f\u56e0\uff1a " + VodCommonResponse2.getMessage();
                PloyvSdkException exception = new PloyvSdkException(VodCommonResponse2.getCode(), message);
                log.error(message, exception);
                throw exception;
            }
        } else {
            String message = "\u4fdd\u5229\u5a01HTTP\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a" + e.getRequestId() + " ,\u9519\u8bef\u539f\u56e0\uff1a \u670d\u52a1\u5668\u63a5\u53e3\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e";
            PloyvSdkException exception = new PloyvSdkException(VodConstant.ERROR_CODE, message);
            log.error(message, exception);
            throw exception;
        }
        t = VodCommonResponse2.parseData(tClass);
        return t;
    }

    protected <T, E extends VodCommonRequest> T basePostJson(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostJson(url, null, e, tClass);
    }

    protected <T, E extends VodCommonRequest> T basePostJson(String url, String pathVariable, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        VodCommonResponse VodCommonResponse2;
        T t = null;
        Map<String, String> paramMap = null;
        if (StringUtils.isBlank(e.getRequestId())) {
            e.setRequestId(VodSignUtil.generateUUID());
        }
        if ((url = url.trim()).startsWith("https://api.polyv.net/")) {
            e.setUserid(VodGlobalConfig.getUserId());
            if (e.getPtime() == null) {
                e.setPtime(System.currentTimeMillis());
            }
            paramMap = MapUtil.objectToMap(e);
            String sign = VodSignUtil.setVodSign(paramMap, VodGlobalConfig.getSecretKey());
            e.setSign(sign);
        } else {
            paramMap = MapUtil.objectToMap(e);
        }
        paramMap = MapUtil.filterNullValue(paramMap);
        this.validateBean(e);
        url = url + "?" + MapUtil.mapJoinNotEncode(paramMap);
        url = String.format(url, pathVariable);
        String response = HttpUtil.postJsonBody(url, JSON.toJSONString(e), Consts.UTF_8.toString());
        if (StringUtils.isNotBlank(response)) {
            VodCommonResponse2 = JSON.parseObject(response, VodCommonResponse.class);
            if (VodCommonResponse2.getCode() != 200) {
                String message = "\u4fdd\u5229\u5a01\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a" + e.getRequestId() + " ,\u9519\u8bef\u539f\u56e0\uff1a " + VodCommonResponse2.getMessage();
                PloyvSdkException exception = new PloyvSdkException(VodCommonResponse2.getCode(), message);
                log.error(message, exception);
                throw exception;
            }
        } else {
            String message = "\u4fdd\u5229\u5a01HTTP\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a" + e.getRequestId() + " ,\u9519\u8bef\u539f\u56e0\uff1a \u670d\u52a1\u5668\u63a5\u53e3\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e";
            PloyvSdkException exception = new PloyvSdkException(VodConstant.ERROR_CODE, message);
            log.error(message, exception);
            throw exception;
        }
        t = VodCommonResponse2.parseData(tClass);
        return t;
    }
}

