/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vod.v1.util;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VodSignUtil {
    private static final Logger log = LoggerFactory.getLogger(VodSignUtil.class);

    public static String generateUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String setVodSign(Map<String, String> params, String appSecret) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String sign = VodSignUtil.getSign(params, appSecret);
        params.put("sign", sign);
        return sign;
    }

    public static String getSign(Map<String, String> params, String secretKey) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        log.debug("\u53c2\u4e0e\u7b7e\u540d\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String plain = "";
        for (String key : keys) {
            if (null == params.get(key) || params.get(key).length() <= 0) continue;
            plain = plain + key + "=" + params.get(key) + "&";
        }
        if (StringUtils.isNotBlank(plain)) {
            plain = plain.substring(0, plain.length() - 1);
        }
        plain = plain + secretKey;
        log.debug("\u7b7e\u540d\u539f\u59cb\u5b57\u7b26\u4e32\uff1a{}", (Object)plain);
        String sign = VodSignUtil.getSha1(plain).toUpperCase();
        log.debug("\u7b7e\u540d\u7ed3\u679c\uff1a{}", (Object)sign);
        return sign;
    }

    public static String getSha1(String input) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest mDigest = MessageDigest.getInstance("SHA1");
        byte[] result = mDigest.digest(input.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (byte b : result) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static String mapJoinNotEncode(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank(value)) continue;
            if (0 != i) {
                stringBuilder.append("&");
            }
            stringBuilder.append(key).append("=").append(map.get(key));
            ++i;
        }
        return stringBuilder.toString();
    }

    public static String mapJoinEncode(Map<String, String> map, boolean keyLower, boolean valueUrlEncode) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank(value)) continue;
            String temp = key.endsWith("_") && key.length() > 1 ? key.substring(0, key.length() - 1) : key;
            stringBuilder.append(keyLower ? temp.toLowerCase() : temp).append("=").append(valueUrlEncode ? URLEncoder.encode(value, "UTF-8").replace("+", "%20") : value).append("&");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

