/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.jrockit.common.util.Debug;
import com.jrockit.common.util.Print;
import com.jrockit.management.rmp.RmpServer;
import com.jrockit.management.rmp.RmpServerProperties;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RmpSocketListener
implements Runnable {
    private static final int ACCEPTED_NO_OF_REFUSED = 3;
    private ServerSocket m_listenerSocket;
    private int m_maxNumberOfConnections;
    private int m_port;
    private List m_serverConnections = new ArrayList();
    private List m_refusedConnections = new ArrayList();
    private static long m_startTime = System.currentTimeMillis();

    public RmpSocketListener() {
        this.setupPort();
        this.setupMaxNumberOfConnections();
        if (this.setupSocket(this.getPort(), this.getMaxNumberOfConnections())) {
            Thread t = new Thread((Runnable)this, "[JRockit] Connection Listener");
            t.setDaemon(true);
            t.start();
        }
    }

    private boolean setupSocket(int serverPort, int maxNoOfConnections) {
        this.m_maxNumberOfConnections = maxNoOfConnections;
        try {
            this.m_listenerSocket = new ServerSocket(serverPort);
            Print.info((String)("Management Server started on port " + serverPort + "."));
        }
        catch (BindException portNotAvailableException) {
            Print.error((String)("Management Server could not be started on port " + serverPort + "."));
            Print.error((String)"This port is probably already in use on this system.");
            return false;
        }
        catch (IOException e) {
            Print.error((String)("Management Server could not be started (using port " + serverPort + ")."));
            Print.exception((Throwable)e);
            return false;
        }
        return true;
    }

    public static long getStartTime() {
        return m_startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        try {
            try {
                while (true) lbl-1000:
                // 4 sources

                {
                    incoming = this.m_listenerSocket.accept();
                    if (this.okToAddConnection()) {
                        Print.info((String)("New Management Server connection from " + incoming.getInetAddress().getHostName()));
                        this.getServerConnections().add(new RmpServer(incoming, this));
                        continue;
                    }
                    if (this.okToAddRefused()) {
                        Print.warning((String)("Management Server connection refused. Connection number limit is " + this.getMaxNumberOfConnections()));
                        this.getRefusedConnections().add(new RmpServer(incoming, this, this.getMaxNumberOfConnections()));
                        continue;
                    }
                    Print.warning((String)("Management Server connection ignored. Connection number limit is " + this.getMaxNumberOfConnections()));
                    incoming.close();
                    var2_3 = this;
                    synchronized (var2_3) {
                        try {
                            this.wait(10000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                Debug.println((String)"Incoming Management Server connection could not be handled");
                Debug.exception((Throwable)e);
                var6_6 = null;
                try {
                    this.m_listenerSocket.close();
                }
                catch (IOException ignored) {}
            }
            {
                ** while (true)
            }
        }
        catch (Throwable var5_10) {
            var6_7 = null;
            try {
                this.m_listenerSocket.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw var5_10;
        }
    }

    public boolean okToAddConnection() {
        if (this.getServerConnections().size() < this.getMaxNumberOfConnections()) {
            return true;
        }
        Iterator iter = this.getServerConnections().iterator();
        while (iter.hasNext()) {
            RmpServer server = (RmpServer)iter.next();
            if (server.isConnected()) continue;
            iter.remove();
        }
        return this.getServerConnections().size() < this.getMaxNumberOfConnections();
    }

    public boolean okToAddRefused() {
        if (this.getRefusedConnections().size() < 3) {
            return true;
        }
        Iterator iter = this.getRefusedConnections().iterator();
        while (iter.hasNext()) {
            RmpServer server = (RmpServer)iter.next();
            if (server.isConnected()) continue;
            iter.remove();
        }
        return this.getRefusedConnections().size() < 3;
    }

    private List getServerConnections() {
        return this.m_serverConnections;
    }

    private List getRefusedConnections() {
        return this.m_refusedConnections;
    }

    private int getMaxNumberOfConnections() {
        return this.m_maxNumberOfConnections;
    }

    private int getPort() {
        return this.m_port;
    }

    private void setupMaxNumberOfConnections() {
        block3: {
            String maxConnectString = null;
            try {
                maxConnectString = System.getProperty("jrockit.managementserver.maxconnect");
                if (maxConnectString == null) {
                    this.m_maxNumberOfConnections = 4;
                    break block3;
                }
                this.m_maxNumberOfConnections = Integer.parseInt(maxConnectString);
            }
            catch (NumberFormatException e) {
                Print.error((String)("Invalid maximum number of connections for Management Server: " + maxConnectString));
                Print.error((String)"Using default value 4 instead.");
                this.m_maxNumberOfConnections = 4;
            }
        }
    }

    private void setupPort() {
        String portString = null;
        try {
            portString = System.getProperty("jrockit.managementserver.port", RmpServerProperties.DEFAULT_PORT);
            this.m_port = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            Print.error((String)("Invalid port number specified for Management Server: " + portString));
            Print.error((String)"Using default port 7090 instead.");
            this.m_port = 7090;
        }
    }
}

