/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Enums;
import springfox.documentation.schema.Example;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.parameter.Examples;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Component(value="swaggerParameterDescriptionReader")
@Order(value=-2147482648)
public class ApiParamParameterBuilder
implements ParameterBuilderPlugin {
    private final DescriptionResolver descriptions;
    private final EnumTypeDeterminer enumTypeDeterminer;

    @Autowired
    public ApiParamParameterBuilder(DescriptionResolver descriptions, EnumTypeDeterminer enumTypeDeterminer) {
        this.descriptions = descriptions;
        this.enumTypeDeterminer = enumTypeDeterminer;
    }

    @Override
    public void apply(ParameterContext context) {
        Optional<ApiParam> apiParam = context.resolvedMethodParameter().findAnnotation(ApiParam.class);
        context.parameterBuilder().allowableValues(this.allowableValues(context.alternateFor(context.resolvedMethodParameter().getParameterType()), apiParam.transform(this.toAllowableValue()).or("")));
        if (apiParam.isPresent()) {
            ApiParam annotation = apiParam.get();
            context.parameterBuilder().name(Strings.emptyToNull(annotation.name())).description(Strings.emptyToNull(this.descriptions.resolve(annotation.value()))).parameterAccess(Strings.emptyToNull(annotation.access())).defaultValue(Strings.emptyToNull(annotation.defaultValue())).allowMultiple(annotation.allowMultiple()).allowEmptyValue(annotation.allowEmptyValue()).required(annotation.required()).scalarExample(new Example(annotation.example())).complexExamples(Examples.examples(annotation.examples())).hidden(annotation.hidden()).collectionFormat(annotation.collectionFormat()).order(-2147482648);
        }
    }

    private Function<ApiParam, String> toAllowableValue() {
        return new Function<ApiParam, String>(){

            @Override
            public String apply(ApiParam input) {
                return input.allowableValues();
            }
        };
    }

    private AllowableValues allowableValues(ResolvedType parameterType, String allowableValueString) {
        AllowableValues allowableValues = null;
        if (!Strings.isNullOrEmpty(allowableValueString)) {
            allowableValues = ApiModelProperties.allowableValueFromString(allowableValueString);
        } else {
            if (this.enumTypeDeterminer.isEnum(parameterType.getErasedType())) {
                allowableValues = Enums.allowableValues(parameterType.getErasedType());
            }
            if (Collections.isContainerType(parameterType)) {
                allowableValues = Enums.allowableValues(Collections.collectionElementType(parameterType).getErasedType());
            }
        }
        return allowableValues;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

